% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{cuda_ml_pca}
\alias{cuda_ml_pca}
\title{Perform principal component analysis.}
\usage{
cuda_ml_pca(
  x,
  n_components = NULL,
  eig_algo = c("dq", "jacobi"),
  tol = 1e-07,
  n_iters = 15L,
  whiten = FALSE,
  transform_input = TRUE,
  cuML_log_level = c("off", "critical", "error", "warn", "info", "debug", "trace")
)
}
\arguments{
\item{x}{The input matrix or dataframe. Each data point should be a row
and should consist of numeric values only.}

\item{n_components}{Number of principal component(s) to keep. Default:
min(nrow(x), ncol(x)).}

\item{eig_algo}{Eigen decomposition algorithm to be applied to the covariance
matrix. Valid choices are "dq" (divid-and-conquer method for symmetric
matrices) and "jacobi" (the Jacobi method for symmetric matrices).
Default: "dq".}

\item{tol}{Tolerance for singular values computed by the Jacobi method.
Default: 1e-7.}

\item{n_iters}{Maximum number of iterations for the Jacobi method.
Default: 15.}

\item{whiten}{If TRUE, then de-correlate all components, making each
component have unit variance  and removing multi-collinearity.
Default: FALSE.}

\item{transform_input}{If TRUE, then compute an approximate representation
of the input data. Default: TRUE.}

\item{cuML_log_level}{Log level within cuML library functions. Must be one of
{"off", "critical", "error", "warn", "info", "debug", "trace"}.
Default: off.}
}
\value{
A PCA model object with the following attributes:
   - "components": a matrix of \code{n_components} rows containing the top
     principal components.
   - "explained_variance": amount of variance within the input data explained
     by each component.
   - "explained_variance_ratio": fraction of variance within the input data
     explained by each component.
   - "singular_values": singular values (non-negative) corresponding to the
     top principal components.
   - "mean": the column wise mean of \code{x} which was used to mean-center
     \code{x} first.
   - "transformed_data": (only present if "transform_input" is set to TRUE)
     an approximate representation of input data based on principal
     components.
   - "pca_params": opaque pointer to PCA parameters which will be used for
     performing inverse transforms.

 The model object can be used as input to the inverse_transform() function to
 map a representation based on principal components back to the original
 feature space.
}
\description{
Compute principal component(s) of the input data. Each feature from the input
will be mean-centered (but not scaled) before the SVD computation takes
place.
}
\examples{

library(cuda.ml)

iris.pca <- cuda_ml_pca(iris[1:4], n_components = 3)
print(iris.pca)
}
