% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods.R
\name{plot.ctsmTMB.profile}
\alias{plot.ctsmTMB.profile}
\title{#' Plot a profile likelihood ctsmTMB object}
\usage{
\method{plot}{ctsmTMB.profile}(x, y, include.opt = TRUE, ...)
}
\arguments{
\item{x}{a profile.ctsmTMB object}

\item{y}{not in use}

\item{include.opt}{boolean which indicates whether or not to include the
total likelihood optimizer in the plot.}

\item{...}{additional arguments}
}
\description{
#' Plot a profile likelihood ctsmTMB object
}
\examples{
library(ctsmTMB)
model <- ctsmTMB$new()

# create model
model$addSystem(dx ~ theta * (mu+u-x) * dt + sigma_x*dw)
model$addObs(y ~ x)
model$setVariance(y ~ sigma_y^2)
model$addInput(u)
model$setParameter(
  theta   = c(initial = 1, lower=1e-5, upper=50),
  mu      = c(initial=1.5, lower=0, upper=5),
  sigma_x = c(initial=1, lower=1e-10, upper=30),
  sigma_y = 1e-2
)
model$setInitialState(list(1,1e-1))

# fit model to data
fit <- model$estimate(Ornstein)

# calculate profile likelihood
out <- profile(fit,parlist=list(theta=NULL))

# plot profile
plot(out)
}
