% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fundingrate.R
\name{get_fundingrate}
\alias{get_fundingrate}
\title{Get the funding rate on futures contracts}
\usage{
get_fundingrate(
 ticker,
 source   = 'binance',
 from     = NULL,
 to       = NULL
)
}
\arguments{
\item{ticker}{A \link{character}-vector of \link{length} 1.
See \code{\link[=available_tickers]{available_tickers()}} for available tickers.}

\item{source}{A \link{character}-vector of \link{length} 1. \code{binance} by default.
See \code{\link[=available_exchanges]{available_exchanges()}} for available exchanges.}

\item{from}{An optional \link{character}-, \link{date}- or
\link{POSIXct}-vector of \link{length} 1. \link{NULL} by default.}

\item{to}{An optional \link{character}-, \link{date}- or
\link{POSIXct}-vector of \link{length} 1. \link{NULL} by default.}
}
\value{
An <[\link[xts]{xts}]>-object containing,

\item{index}{<\link{POSIXct}> the time-index}
\item{funding_rate}{<\link{numeric}> the current funding rate}

\strong{Sample output}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#>                     funding_rate
#> 2024-03-09 17:00:00   0.00026407
#> 2024-03-10 01:00:00   0.00031010
#> 2024-03-10 09:00:00   0.00063451
#> 2024-03-10 17:00:00   0.00054479
#> 2024-03-11 01:00:00   0.00035489
#> 2024-03-11 09:00:00   0.00078428
}\if{html}{\out{</div>}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Get the funding rate on a cryptocurrency pair from
the \code{\link[=available_exchanges]{available_exchanges()}} in any actively
traded \code{\link[=available_tickers]{available_tickers()}} on the futures markets.
}
\examples{
\dontrun{
# script start;

# 1) check available
# exchanges for funding rates
cryptoQuotes::available_exchanges(
  type = "fundingrate"
  )

# 2) get BTC funding rate
# for the last 7 days
tail(
  BTC <- cryptoQuotes::get_fundingrate(
    ticker = "BTCUSDT",
    source = "binance",
    from   = Sys.Date() - 7
  )
)

# script end;
}
}
\seealso{
Other get-functions: 
\code{\link{get_fgindex}()},
\code{\link{get_lsratio}()},
\code{\link{get_openinterest}()},
\code{\link{get_quote}()}
}
\author{
Serkan Korkmaz
}
\concept{get-functions}
