% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_S3.R
\name{unit_cell}
\alias{unit_cell}
\title{Constructor for an S3 object of class "unit_cell.}
\usage{
unit_cell(a = NULL, b = NULL, c = NULL, aa = NULL, bb = NULL, cc = NULL)
}
\arguments{
\item{a}{A real number. One of the unit cell's side lengths, in angstroms.}

\item{b}{A real number. One of the unit cell's side lengths, in angstroms.}

\item{c}{A real number. One of the unit cell's side lengths, in angstroms.}

\item{aa}{A real number. One of the unit cell's angles, in degrees.}

\item{bb}{A real number. One of the unit cell's angles, in degrees.}

\item{cc}{A real number. One of the unit cell's angles, in degrees.}
}
\value{
An object of class "unit_cell". It is a named list of length 6 whose
        last three slots are of "angle" class.
}
\description{
This represents a crystal unit cell.
}
\details{
The constructor can be used with less than the full set of six input parameters,
to create unit cells for the cubic, tetragonal and orthogonal systems. Objects
of "unit_cell" class can also be created with no parameters (default to a cubic
cell of side length 10 angstroms).
}
\examples{
# Create a monoclinic unit cell
uc <- unit_cell(10,30,15,90,60,90)
print(uc)

# Create a cubic cell (default)
uc <- unit_cell()
print(uc)

# Create a cubic cell with side 20
uc <- unit_cell(20)
print(uc)

# Create a tetragonal unit cell with sides 20 and 60
uc <- unit_cell(20,60)
print(uc)

# Create an orthogonal unit cell
uc <- unit_cell(40,15,30)
print(uc)

}
