% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.crossnma.R
\name{print.crossnma}
\alias{print.crossnma}
\title{Print results of cross-design & -format network meta-analysis or
regression}
\usage{
\method{print}{crossnma}(x, backtransf = x$model$backtransf, digits = gs("digits"), ...)
}
\arguments{
\item{x}{An object of class \code{crossnma}.}

\item{backtransf}{A logical indicating whether results should be
back transformed. If \code{backtransf = TRUE}, results for
\code{sm = "OR"} are presented as odds ratios rather than log
odds ratios, for example.}

\item{digits}{The number of significant digits printed.}

\item{\dots}{Additional arguments.}
}
\value{
No return value (print function).
}
\description{
Print call used to create JAGS model for cross-design & -format
network meta-analysis or regression
}
\examples{
\dontrun{
# We conduct a network meta-analysis assuming a random-effects
# model.
# The data comes from randomized-controlled trials and
# non-randomized studies (combined naively)
head(ipddata) # participant-level data
stddata # study-level data

# Create a JAGS model
mod <- crossnma.model(treat, id, relapse, n, design,
  prt.data = ipddata, std.data = stddata,
  reference = "A", trt.effect = "random", method.bias = "naive")

# Fit JAGS model
# (suppress warning 'Adaptation incomplete' due to n.adapt = 20)
fit <-
  suppressWarnings(crossnma(mod))
fit
}

}
\seealso{
\code{\link{crossnma}}
}
\author{
Tasnim Hamza \email{hamza.a.tasnim@gmail.com}, Guido
  Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{print}
