% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordcloud.R
\name{word_cloud.cranly_network}
\alias{word_cloud.cranly_network}
\alias{word_cloud}
\alias{word_cloud.numeric}
\title{wordcloud of author names, package descriptions, and package titles}
\usage{
\method{word_cloud}{cranly_network}(
  x,
  package = Inf,
  author = Inf,
  maintainer = Inf,
  base = TRUE,
  recommended = TRUE,
  exact = TRUE,
  perspective = "description",
  random_order = FALSE,
  ignore_words = c("www.jstor.org", "www.arxiv.org", "arxiv.org", "provides", "https"),
  stem = FALSE,
  colors = rev(colorspace::heat_hcl(10)),
  ...
)

\method{word_cloud}{numeric}(
  x,
  random_order = FALSE,
  colors = rev(colorspace::heat_hcl(10)),
  ...
)
}
\arguments{
\item{x}{either a  \code{\link{cranly_network}} object or a named vector of term frequencies (typically the output of \code{\link[=compute_term_frequency]{compute_term_frequency()}} with \code{frequency = "term"}.}

\item{package}{a vector of character strings with the package names to be matched. Default is \code{\link{Inf}} which returns all available packages in \code{x} for further subsetting.}

\item{author}{a vector of character strings with the author names to be matched. Default is \code{Inf} which returns all available author in \code{x} for further subsetting.}

\item{maintainer}{a vector of character strings with the maintainer names to be matched. Default is \code{Inf} which returns all available maintainers in \code{x} for further subsetting.}

\item{base}{logical. Should we include base packages in the subset? Default is \code{TRUE}.}

\item{recommended}{logical. Should we include recommended packages in the subset? Default is \code{TRUE}.}

\item{exact}{logical. Should we use exact matching? Default is \code{TRUE}.}

\item{perspective}{should the wordcloud be that of package descriptions (\code{perspective = "description"}; default), of package titles (\code{perspective = "title"}) or of author names (\code{perspective = "author"}).}

\item{random_order}{should words be plotted in random order? If \code{FALSE} (default) words are plotted in decreasing frequency.}

\item{ignore_words}{a vector of words to be ignored when forming the corpus.}

\item{stem}{should words be stemmed using Porter's stemming algorithm? Default is \code{FALSE}. See \code{\link[tm:stemDocument]{tm::stemDocument()}}.}

\item{colors}{color words from least to most frequent}

\item{...}{other arguments to be passed to \link[wordcloud:wordcloud]{wordcloud::wordcloud} (except \code{random.order} which is already defined through \code{random_order}).}
}
\value{
A word cloud.
}
\description{
wordcloud of author names, package descriptions, and package titles
}
\details{
When applied to \code{\link{cranly_network}} objects, \code{\link[=word_cloud]{word_cloud()}} subsets
either according to \code{author} (using the intersection of the result
of \code{\link[=author_of]{author_of()}} and \code{\link[=author_with]{author_with()}}) or according to package
(using the intersection of the results of \code{\link[=package_with]{package_with()}} and
\code{\link[=package_by]{package_by()}}).

For handling more complex queries, one can manually extract the #'
term frequencies from a supplied vector of character strings (see
\code{\link[=compute_term_frequency]{compute_term_frequency()}}), and use \code{\link[=word_cloud]{word_cloud()}} on them. See the
examples.
}
\examples{
\donttest{
## Package directives network
cran_db <- clean_CRAN_db()
package_network <- build_network(cran_db)
## Descriptions of all packages in tidyverse
tidyverse <- imported_by(package_network, "tidyverse", exact = TRUE)
set.seed(123)
word_cloud(package_network, package = tidyverse, exact = TRUE, min.freq = 2)

## or by manually creating the term frequencies from descriptions
descriptions <- descriptions_of(package_network, tidyverse, exact = TRUE)
term_freq <- compute_term_frequency(descriptions)
set.seed(123)
word_cloud(term_freq, min.freq = 2)
}

}
\seealso{
\code{\link[=compute_term_frequency]{compute_term_frequency()}}
}
