% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R, R/zzz_aliases.R
\name{extractor-functions}
\alias{extractor-functions}
\alias{package_by}
\alias{package_with}
\alias{author_with}
\alias{author_of}
\alias{suggested_by}
\alias{imported_by}
\alias{dependency_of}
\alias{linked_by}
\alias{enhanced_by}
\alias{suggesting}
\alias{importing}
\alias{depending_on}
\alias{linking_to}
\alias{enhancing}
\alias{maintainer_of}
\alias{maintained_by}
\alias{email_of}
\alias{email_with}
\alias{description_of}
\alias{title_of}
\alias{license_of}
\alias{version_of}
\alias{release_date_of}
\alias{package_by.cranly_network}
\alias{package_with.cranly_network}
\alias{author_of.cranly_network}
\alias{author_with.cranly_network}
\alias{suggested_by.cranly_network}
\alias{suggesting.cranly_network}
\alias{imported_by.cranly_network}
\alias{importing.cranly_network}
\alias{dependency_of.cranly_network}
\alias{depending_on.cranly_network}
\alias{linked_by.cranly_network}
\alias{linking_to.cranly_network}
\alias{enhanced_by.cranly_network}
\alias{enhancing.cranly_network}
\alias{maintainer_of.cranly_network}
\alias{maintained_by.cranly_network}
\alias{email_of.cranly_network}
\alias{email_with.cranly_network}
\alias{description_of.cranly_network}
\alias{title_of.cranly_network}
\alias{license_of.cranly_network}
\alias{version_of.cranly_network}
\alias{release_date_of.cranly_network}
\alias{packages_by}
\alias{packages_with}
\alias{authors_with}
\alias{authors_of}
\alias{emails_of}
\alias{emails_with}
\alias{descriptions_of}
\alias{titles_of}
\alias{licenses_of}
\alias{release_dates_of}
\alias{versions_of}
\title{Find packages, authors, maintainers, license, versions etc by authors, packages or names matching a specific string}
\usage{
\method{package_by}{cranly_network}(x, author = NULL, exact = FALSE, flat = TRUE)

\method{package_with}{cranly_network}(x, name = NULL, exact = FALSE, flat = TRUE)

\method{author_of}{cranly_network}(x, package = NULL, exact = FALSE, flat = TRUE)

\method{author_with}{cranly_network}(x, name = NULL, exact = FALSE, flat = TRUE)

\method{suggested_by}{cranly_network}(x, package = NULL, exact = FALSE, flat = TRUE)

\method{suggesting}{cranly_network}(x, package = NULL, exact = FALSE, flat = TRUE)

\method{imported_by}{cranly_network}(x, package = NULL, exact = FALSE, flat = TRUE)

\method{importing}{cranly_network}(x, package = NULL, exact = FALSE, flat = TRUE)

\method{dependency_of}{cranly_network}(x, package = NULL, exact = FALSE, flat = TRUE)

\method{depending_on}{cranly_network}(x, package = NULL, exact = FALSE, flat = TRUE)

\method{linked_by}{cranly_network}(x, package = NULL, exact = FALSE, flat = TRUE)

\method{linking_to}{cranly_network}(x, package = NULL, exact = FALSE, flat = TRUE)

\method{enhanced_by}{cranly_network}(x, package = NULL, exact = FALSE, flat = TRUE)

\method{enhancing}{cranly_network}(x, package = NULL, exact = FALSE, flat = TRUE)

\method{maintainer_of}{cranly_network}(x, package = NULL, exact = FALSE, flat = TRUE)

\method{maintained_by}{cranly_network}(x, author = NULL, exact = FALSE, flat = TRUE)

\method{email_of}{cranly_network}(x, author = NULL, exact = FALSE, flat = TRUE)

\method{email_with}{cranly_network}(x, name = NULL, exact = FALSE, flat = TRUE)

\method{description_of}{cranly_network}(x, package = NULL, exact = FALSE, flat = TRUE)

\method{title_of}{cranly_network}(x, package = NULL, exact = FALSE, flat = TRUE)

\method{license_of}{cranly_network}(x, package = NULL, exact = FALSE, flat = TRUE)

\method{version_of}{cranly_network}(x, package = NULL, exact = FALSE, flat = TRUE)

\method{release_date_of}{cranly_network}(x, package = NULL, exact = FALSE, flat = TRUE)

packages_by(x, author, exact, flat)

packages_with(x, name = NULL, exact = FALSE, flat = TRUE)

authors_with(x, name = NULL, exact = FALSE, flat = TRUE)

authors_of(x, package = NULL, exact = FALSE, flat = TRUE)

emails_of(x, author = NULL, exact = FALSE, flat = TRUE)

emails_with(x, name = NULL, exact = FALSE, flat = TRUE)

descriptions_of(x, package = NULL, exact = FALSE, flat = TRUE)

titles_of(x, package = NULL, exact = FALSE, flat = TRUE)

licenses_of(x, package = NULL, exact = FALSE, flat = TRUE)

release_dates_of(x, package = NULL, exact = FALSE, flat = TRUE)

versions_of(x, package = NULL, exact = FALSE, flat = TRUE)
}
\arguments{
\item{x}{a  \code{\link{cranly_network}} object.}

\item{author}{a vector of character strings with the author names to be matched. If \code{Inf} all available authors in \code{x} are returned. If \code{NULL} (default) nothing is matched.}

\item{exact}{logical. Should we use exact matching? Default is \code{TRUE}.}

\item{flat}{if \code{TRUE} (default) then the result is an unnamed character vector. See Value for more details of what is returned.}

\item{name}{a vector of character strings with the names to be matched. If \code{Inf} all available names in \code{x} are returned. If \code{NULL} (default) nothing is matched.}

\item{package}{a vector of character strings with the package names to be matched. If \code{Inf} all available packages in \code{x} are returned. If \code{NULL} (default) nothing is matched.}
}
\value{
If \code{flat = TRUE} then the result of the extraction function is a
\code{data.frame}, which is the subset of \code{x$nodes} matching \code{author},
\code{name} or \code{package} (according to the value of \code{exact}). If \code{flat = FALSE} then the results is a vector.

When \code{flat = TRUE} any \code{\link{NA}}s are removed before the result is
returned.
}
\description{
Find packages, authors, maintainers, license, versions etc by authors, packages or names matching a specific string
}
\details{
The extractor functions all try to figure out what \code{y} is in the statement

\code{y} is (the) \verb{extractor-function} a \code{package}/\code{author}.

For example, for
\itemize{
\item "\code{y} is the package by \code{"Kurt Hornik"}" we do \code{package_by(x, "Kurt Hornik")}
\item "\code{y} is the author of a package with a name matching \code{"MASS"}" we do \code{author_of(x, "MASS")}
\item "\code{y} is the package enhanced by the \code{"prediction"} package we do \code{enhanced_by(x, "prediction", exact = TRUE)}
\item "\code{y} is the package linking to \code{"Rcpp"} we do \code{linking_to(x, "Rcpp", exact = TRUE)}
}
}
\examples{
\donttest{
# Using a package directives network
cran_db <- clean_CRAN_db()
package_network <- build_network(cran_db)

## Find all packages containing glm in their name
package_with(package_network, name = "glm")
## Find all authors of packages containing brglm in their name
author_of(package_network, package = "rglm", exact = FALSE)
## Find all packages with brglm in their name
package_with(package_network, name = "rglm", exact = FALSE)
## Find all authors of the package brglm2
author_of(package_network, package = "brglm2", exact = TRUE)
## Find all authors with Ioannis in their name
author_with(package_network, name = "Ioannis", exact = FALSE)
## Find all packages suggested by Rcpp
suggested_by(package_network, package = "Rcpp", exact = TRUE)
## Find all packages imported by Rcpp
imported_by(package_network, package = "Rcpp", exact = TRUE)
## Find all packages enhacing brglm
enhancing(package_network, package = "brglm", exact = TRUE)
## Find all packages linking to RcppArmadillo
linking_to(package_network, package = "RcppArmadillo", exact = TRUE)
## Find the release date of RcppArmadillo
release_date_of(package_network, package = "RcppArmadillo", exact = TRUE)
## Find the release data of all packages with "brglm" in their name
release_date_of(package_network, package = "brglm", exact = FALSE)
## More information about packages with "brglm" in their name
release_date_of(package_network, package = "brglm", exact = FALSE,
                flat = FALSE)[c("package", "version")]

## Using an author collaboration network
author_network <- build_network(cran_db, perspective = "author")
## Find all packages containing glm in their name
package_with(author_network, name = "glm")
## Find all authors of packages containing brglm in their name
author_of(author_network, package = "rglm", exact = FALSE)
## Find all packages with brglm in their name
package_with(author_network, name = "rglm", exact = FALSE)
## Find all authors of the package brglm2
author_of(author_network, package = "brglm2", exact = TRUE)
## Find all authors with Ioannis in their name
author_with(author_network, name = "Ioannis", exact = FALSE)
}


}
\seealso{
\code{\link[=build_network.cranly_db]{build_network.cranly_db()}} \code{\link[=subset.cranly_network]{subset.cranly_network()}} \code{\link[=plot.cranly_network]{plot.cranly_network()}}
}
