% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_zero_recode.R
\name{modify_zero_recode}
\alias{modify_zero_recode}
\title{Zero Count Recode}
\usage{
modify_zero_recode(x)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
a gtsummary table}
}
\value{
a gtsummary table
}
\description{
This function removes the percentage from cells with zero counts.
For example,

\if{html}{\out{<div class="sourceCode r">}}\preformatted{0 (0.0\%)      -->  0
0 (0\%)        -->  0
0 (NA\%)       -->  0
0 / nn (0\%)   -->  0 / nn
0/nn (0.0\%)   -->  0/nn
0 / 0 (NA\%)   -->  0 / 0
}\if{html}{\out{</div>}}
}
\details{
The function is a wrapper for \code{gtsummary::modify_post_fmt_fun()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gtsummary::modify_post_fmt_fun(
  x,
  fmt_fun = \\(x) \{
    dplyr::case_when(
      # convert "0 (0\%)" OR "0 (0.0\%)" OR 0 (NA\%) to "0"
      str_detect(x, "^0\\\\s\\\\((?:0(?:\\\\.0)?|NA)\%\\\\)$") ~ str_remove(x, pattern = "\\\\s\\\\((?:0(?:\\\\.0)?|NA)\%\\\\)$"),
      # convert "0 / nn (0\%)" OR "0/nn (0.0\%)" OR 0/0 (NA\%) to "0 / nn" OR "0/nn" OR "0/0"
      str_detect(x, pattern = "^(0 ?/) ?\\\\d+[^()]* \\\\((?:0(?:\\\\.0)?|NA)\%\\\\)$") ~ str_remove(x, pattern = "\\\\s\\\\((?:0(?:\\\\.0)?|NA)\%\\\\)$"),
      .default = x
    )
  \},
  columns = gtsummary::all_stat_cols()
)
}\if{html}{\out{</div>}}
}
\examples{
trial |>
  dplyr::mutate(trt = factor(trt, levels = c("Drug A", "Drug B", "Drug C"))) |>
  tbl_summary(include = trt) |>
  modify_zero_recode()
}
