% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cprobit.R
\docType{data}
\name{bg_variability}
\alias{bg_variability}
\title{Inpatient blood glucose data for 1200 patients}
\format{
A data frame with 1200 rows and 7 variables:
\describe{
  \item{subject_id}{Subject ID of each patient.}
  \item{case_id}{Case ID, with \code{1} and \code{2} referring to the first
  and second follow-up respectively.}
  \item{y}{BG variability of the first and second follow-up.}
  \item{t}{Binary indicator for the second follow-up.}
  \item{sd0}{Baseline BG variability.}
  \item{age}{Patients' age.}
  \item{female}{Binary indicator for being female.}
}
}
\usage{
bg_variability
}
\description{
A simulated dataset containing the variability of inpatient
  point-of-care blood glucose (BG) measurements from 1200 non-critical care
  adult patients in medical ward. BG variability is measured as the standard
  deviation of the BG readings within a day. Data was simulated based on real
  data.
}
\keyword{datasets}
