% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_t_copula_samples.R
\name{generate_t_copula_samples}
\alias{generate_t_copula_samples}
\title{Generate t-Copula Samples}
\usage{
generate_t_copula_samples(n, d, rho_matrix, df)
}
\arguments{
\item{n}{Integer. The number of samples to generate.}

\item{d}{Integer. The dimensionality of the copula.}

\item{rho_matrix}{A \code{d x d} positive-definite correlation matrix.}

\item{df}{Numeric. The degrees of freedom of the t-distribution. Must be positive.}
}
\value{
A matrix of size \code{n x d}, where each row represents a sample
and each column corresponds to a dimension. The values are uniformly
distributed in \code{[0, 1]}.
}
\description{
This function generates samples from a t-copula given a specified correlation
matrix and degrees of freedom. The samples are uniformly distributed in \code{[0, 1]}.
across dimensions.
}
\details{
The function works as follows:
\enumerate{
\item Generates multivariate t-distributed samples using the specified
correlation matrix and degrees of freedom.
\item Transforms the samples to the uniform distribution \code{[0, 1]} using the
cumulative distribution function (CDF) of the t-distribution.
}
}
\examples{
# Example usage:
library(mvtnorm)  # Load package for `rmvt`
rho_matrix <- diag(3)  # 3x3 identity matrix as correlation matrix
samples <- generate_t_copula_samples(n = 1000, d = 3, rho_matrix = rho_matrix, df = 5)
head(samples)

}
