% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countfitteR-package.R
\docType{package}
\name{countfitteR-package}
\alias{countfitteR-package}
\alias{countfitteR}
\title{countfitteR - a framework for fitting count distributions in R}
\description{
The \code{countfitteR} package is a toolbox for the analysis of
count data.
}
\section{Acknowledgements}{

countfitteR is a wrapper around existing count models in R. To standardize error messages 
and ease up the integration, we slightly modified the \code{\link[pscl]{zeroinfl}} 
function by Achim Zeileis.
}

\examples{
set.seed(15390)
library(countfitteR)
df <- data.frame(pois = rpois(25, 0.3), 
                 binom = rbinom(25, 1, 0.8))

cmp <- compare_fit(df, fitlist = fit_counts(df, model = "all"))
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/BioGenies/countfitteR}
  \item Report bugs at \url{https://github.com/BioGenies/countfitteR/issues}
}

}
\author{
Jaroslaw Chilimoniuk, Stefan Roediger, Michal Burdukiewcz
}
