\name{EL and EEL test for a correlation coefficient}
\alias{el.cor.test}
\alias{eel.cor.test}
\title{
EL and EEL test for a correlation coefficient
}

\description{
EL and EEL test for a correlation coefficient.
}

\usage{
el.cor.test(y, x, rho, tol = 1e-07)
el.cor.test(y, x, rho, tol = 1e-07)
}

\arguments{
\item{y}{
A numerical vector.
}
\item{x}{
A numerical vector.
}
\item{rho}{
The hypothesized value of the true partial correlation.
}
\item{tol}{
The tolerance vlaue to terminate the Newton-Raphson algorithm.
}
}

\details{
The empirical likelihood (EL) or the exponential empirical likelihood (EEL) test is performed for the Pearson correlation coefficient. At first we standardise the data so that the sample correlation equal the inner product between the two variables, \eqn{\hat{r}=\sum_{i=1}^nx_iy_i}, where \eqn{n} is the sample size.

The EL works by minimizing the quantity \eqn{\sum_{i=1}^n\log{nw_i}} subject to the constraints \eqn{\sum_{i=1}^nw_i(x_iy_i-\rho)=0}, \eqn{\sum_{i=1}^nw_i=1} and \eqn{\rho} is the hypothesised correlation coefficient, under the \eqn{H_0}. After some algebra the form of the weights \eqn{w_i} becomes
\deqn{
w_i=\frac{1}{n}\frac{1}{1+\lambda(x_iy_i-\rho)},
}
where \eqn{\lambda} is the Lagrange multiplier of the first (zero sum) constraint. Thus, the zero sum constraint becomes \eqn{\sum_{i=1}^n\frac{x_iy_i-\rho}{1 + \lambda(x_iy_i-\rho)}=0} and this equality is solved with respect to \eqn{\lambda} via the Newton-Raphson algortihm. The derivative of this function is \eqn{-\sum_{i=1}^n\frac{(x_iy_i-\rho)^2}{\left[1 + \lambda(x_iy_i-\rho)\right]^2}=0}.

The EL works by minimizing the quantity \eqn{\sum_{i=1}^nw_i\log{nw_i}} subject to the same constraints as before, \eqn{\sum_{i=1}^nw_i(x_iy_i-\rho)=0} or \eqn{\sum_{i=1}^nw_i(x_iy_i)=\rho}, \eqn{\sum_{i=1}^nw_i=1}. After some algebra the form of the weights \eqn{w_i} becomes
\deqn{
w_i=\frac{e^{\lambda x_iy_i}}{\sum_{j=1}^ne^{\lambda x_jy_j}},
}
where, again, \eqn{\lambda} is the Lagrange multiplier of the first (zero sum) constraint. Thus, the zero sum constraint becomes \eqn{\frac{\sum_{i=1}^nx_iy_ie^{\lambda x_iy_i}}{\sum_{j=1}^ne^{\lambda x_jy_j}}-\rho=0} and this equality is solved with respect to \eqn{\lambda} via the Newton-Raphson algortihm. The derivative of this function is
\deqn{
\frac{\sum_{i=1}^n(x_iy_i)^2e^{\lambda x_iy_i} * \sum_{i=1}^ne^{\lambda x_iy_i} - \left(\sum_{i=1}^nx_iy_ie^{\lambda x_iy_i}\right)^2}{\left(\sum_{j=1}^ne^{\lambda x_jy_j}\right)^2}.
}
}

\value{
A list including:
\item{iters}{
The number of iterations required by the Newton-Raphson. If no convergence occured this is NULL.
}
\item{info}{
A vector with three values, the value of \eqn{\lambda}, the test statistic and its associated asymptotic p-value.
If no convergence occured, the value of the \eqn{\lambda} is NA, the value of test statistic is \eqn{10^5}
and the p-value is 0. No convergence can be interpreted as rejection of the hypothesis test.
}
\item{p}{
The probabilities of the EL or of the EEL. If no covnergence occured this is NULL.
}
}

\references{
Efron B. (1981) Nonparametric standard errors and confidence intervals. Canadian Journal of
Statistics, 9(2): 139--158.

Owen A. B. (2001). Empirical likelihood. Chapman and Hall/CRC Press.
}

\author{
Michail Tsagris

R implementation and documentation: Michail Tsagris \email{mtsagris@uoc.gr}.
}

%\note{
%%  ~~further notes~~
%}

\seealso{
\code{ \link{perm.elcortest}, \link{correl}, \link{permcor}
}
}

\examples{
el.cor.test( iris[, 1], iris[, 2], 0 )$info
eel.cor.test( iris[, 1], iris[, 2], 0 )$info
}


