% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrSolar.R
\name{corrSolar}
\alias{corrSolar}
\title{corrSolar}
\usage{
corrSolar(mat, sun = NULL)
}
\arguments{
\item{mat}{A square correlation matrix to visualise.}

\item{sun}{A character string specifying the column name in the dataset to
be treated as the 'sun' in the solar system plot.}
}
\value{
An solar system plot displaying correlations.
}
\description{
This function creates a solar system plot of correlations between
variables in a dataset.
}
\details{
In a solar system correlation plot, the dependent variable of
interest is positioned at the center, represented as the sun.
The explanatory variables are depicted as planets orbiting
around the sun, with their distance from the sun corresponding
to the absolute value of their correlation with the dependent variable.
Therefore, the greater the distance of a planet from the sun,
the weaker the correlation between the explanatory variable
and the dependent variable.
}
\examples{
cm <- cor(mtcars)
corrSolar(mat = cm,
          sun = 'mpg')


}
