\name{assoc_comb}
\alias{assoc_comb}

\title{
Complete association matrix.
}
\description{
All the six possible association matrices can be merged in to a single matrix to visualize the overall association among positions as well as among the occurences of nucleotides of different positions, in a position-wise aligned sequence dataset.
}
\usage{
assoc_comb(x, rZiZj, rZiZjR, rZiZjY, rZiRZjR, rZiRZjY, rZiYZjY)
}

\arguments{
  \item{x}{
A dataframe of position wise aligned sequence dataset having A, T, G and C only.
}
  \item{rZiZj}{
An object generated by using the function \code{\link{assoc_Zi.Zj}}.
}
  \item{rZiZjR}{
An object generated by using the function \code{\link{assoc_Zi.ZjR}}.
}
  \item{rZiZjY}{
An object generated by using the function \code{\link{assoc_Zi.ZjY}}.
}
  \item{rZiRZjR}{
An object generated by using the function \code{\link{assoc_ZiR.ZjR}}.
}
  \item{rZiRZjY}{
An object generated by using the function \code{\link{assoc_ZiR.ZjY}}.
}
  \item{rZiYZjY}{
An object generated by using the function \code{\link{assoc_ZiY.ZjY}}.
}
}
\details{
All the six association matrices are required to be generated prior to merging them into a single matrix.
}
\value{
A numeric matrix of order \emph{3L} by \emph{3L} for the dataset of \emph{L} nucleotides long sequences.
}

\author{
Prabina Kumar Meher & A. R. Rao
}

\examples{
\donttest{
data(don_dat)
kk <- don_dat[1:300,]
zizj <- assoc_Zi.Zj(x=kk)
zizjr <- assoc_Zi.ZjR(x=kk, rZiZj=zizj)
zizjy <- assoc_Zi.ZjY(x=kk, rZiZj=zizj)
zirzjr <- assoc_ZiR.ZjR(x=kk,rZiZj=zizj,rZiZjR=zizjr)
zirzjy <- assoc_ZiR.ZjY(x=kk,rZiZj=zizj,rZiZjR=zizjr,rZiZjY=zizjy)
ziyzjy <- assoc_ZiY.ZjY(x=kk,rZiZj=zizj,rZiZjY=zizjy)
fin_corr <- assoc_comb(x=kk, rZiZj=zizj,rZiZjR=zizjr,rZiZjY=zizjy,
rZiRZjR=zirzjr,rZiRZjY=zirzjy,rZiYZjY=ziyzjy)
fin_corr
}
}
