% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_functions.R
\name{semantic_similarity}
\alias{semantic_similarity}
\title{Calculate semantic similarity between two conversations}
\usage{
semantic_similarity(
  conversation1,
  conversation2,
  method = "tfidf",
  model_path = NULL,
  dim = 100,
  window = 5,
  iter = 5
)
}
\arguments{
\item{conversation1}{A character string representing the first conversation}

\item{conversation2}{A character string representing the second conversation}

\item{method}{A character string specifying the method to use: "tfidf", "word2vec", or "glove"}

\item{model_path}{A character string specifying the path to pre-trained GloVe file (required for "glove" method)}

\item{dim}{An integer specifying the dimensionality for Word2Vec embeddings (default: 100)}

\item{window}{An integer specifying the window size for Word2Vec (default: 5)}

\item{iter}{An integer specifying the number of iterations for Word2Vec (default: 5)}
}
\value{
A numeric value representing the semantic similarity (between 0 and 1)
}
\description{
This function calculates the semantic similarity between two conversations
using either TF-IDF, Word2Vec, or GloVe embeddings approach.
}
\examples{
conv1 <- "The quick brown fox jumps over the lazy dog"
conv2 <- "A fast auburn canine leaps above an idle hound"
semantic_similarity(conv1, conv2, method = "tfidf")
}
