% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-get_datalog.R
\name{get_datalog}
\alias{get_datalog}
\title{Get datalog for elements in project}
\usage{
get_datalog(
  element_ids_to_fetch = NULL,
  from_time = NULL,
  to_time = NULL,
  interval = NULL,
  raw = FALSE
)
}
\arguments{
\item{element_ids_to_fetch}{The element ids to fetch (\code{list}, Max 25).}

\item{from_time}{The from date (\code{POSIXct} or numeric).}

\item{to_time}{The to date (\code{POSIXct} or numeric).}

\item{interval}{The interval (optional, in seconds).}

\item{raw}{If TRUE, return the raw JSON response.}
}
\value{
A data frame with the datalog information.
}
\description{
Get the datalog for multiple elements in a project from Consibio APIs.
}
\details{
See details in https://api.v2.consibio.com/api-docs/#/default/get_projects__project_id__datalog
}
\examples{
\dontrun{
get_datalog(
  element_ids_to_fetch = c("{element_id}"),
  from_time = as.POSIXct("2021-01-01"), to_time = as.POSIXct("2021-01-02")
)
}
}
