% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connector_imports.R, R/volume_methods.R
\name{upload_cnt}
\alias{upload_cnt}
\alias{upload_cnt.ConnectorDatabricksVolume}
\title{Upload content to the connector}
\usage{
upload_cnt(
  connector_object,
  src,
  dest = basename(src),
  overwrite = zephyr::get_option("overwrite", "connector"),
  ...
)

\method{upload_cnt}{ConnectorDatabricksVolume}(
  connector_object,
  src,
  dest = basename(src),
  overwrite = zephyr::get_option("overwrite", "connector.databricks"),
  ...
)
}
\arguments{
\item{connector_object}{\link[connector]{Connector} The connector object to use.}

\item{src}{\link{character} Path to the file to download to or upload from}

\item{dest}{\link{character} Name of the content to read, write, or remove. Typically the table name.}

\item{overwrite}{Overwrites existing content if it exists in the connector.}

\item{...}{\link{ConnectorDatabricksVolume}: Additional parameters to pass to the
\code{\link[brickster:db_volume_write]{brickster::db_volume_write()}} method}
}
\value{
\link{invisible} connector_object.
}
\description{
Additional list content methods for Databricks connectors implemented for
\code{\link[connector:upload_cnt]{connector::upload_cnt()}}:

\itemize{
\item \link{ConnectorDatabricksVolume}: Reuses the \code{\link[connector:upload_cnt]{connector::upload_cnt()}}
method for \link{ConnectorDatabricksVolume}, but always
sets the \code{catalog}, \code{schema} and \code{path} as defined in when initializing the
connector.
}
}
