% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewer-based-credentials.R
\name{connect_viewer_token}
\alias{connect_viewer_token}
\alias{has_viewer_token}
\title{Viewer-based credentials on Posit Connect}
\usage{
connect_viewer_token(
  resource = NULL,
  scope = NULL,
  session = get_connect_session(),
  server_url = Sys.getenv("CONNECT_SERVER"),
  api_key = Sys.getenv("CONNECT_API_KEY")
)

has_viewer_token(..., session = get_connect_session())
}
\arguments{
\item{resource}{The URI that identifies the resource that the client is
trying to access, if applicable.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{session}{A Shiny session object. By default, this grabs the Shiny
session of the parent environment (if any), provided we are also running on
Connect.}

\item{server_url}{The Connect server to exchange credentials with. Defaults
to the value of the \code{CONNECT_SERVER} environment variable, which is set
automatically when running on Connect.}

\item{api_key}{An API key for the Connect server. Defaults to the value of
the \code{CONNECT_API_KEY} environment variable, which is set automatically when
running on Connect.}

\item{...}{Further arguments passed on to \code{\link[=connect_viewer_token]{connect_viewer_token()}}.}
}
\value{
\code{\link[=connect_viewer_token]{connect_viewer_token()}} returns an \link[httr2:oauth_token]{httr2::oauth_token}.

\code{\link[=has_viewer_token]{has_viewer_token()}} returns \code{TRUE} if the session has a viewer
token and \code{FALSE} otherwise.
}
\description{
Request an OAuth access token for a third-party resource belonging to the
user associated with a given Shiny session. This works by exchanging a
short-lived session credential for OAuth tokens issued to the client managed
by the Connect server, without the Shiny app in question having to manage the
user's authentication flow (or the associated client credentials) itself.
}
\details{
\code{connect_viewer_token()} handles caching automatically.
}
\examples{
token <- "default-token"
if (has_viewer_token()) {
  token <- connect_viewer_token()
}
}
