% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrations.R
\name{get_integrations}
\alias{get_integrations}
\title{Get OAuth integrations}
\usage{
get_integrations(x)
}
\arguments{
\item{x}{A \code{Connect} or \code{Content} R6 object.}
}
\value{
A list of class \code{connect_integration_list}, where each element is a \code{connect_integration} object
with the following fields. (Raw API fields are character strings unless noted otherwise):
\itemize{
\item \code{id}: The internal identifier of this OAuth integration.
\item \code{guid}: The GUID of this OAuth integration.
\item \code{created_time}: Timestamp (RFC3339) when the integration was created.
\item \code{updated_time}: Timestamp (RFC3339) when the integration was last updated.
\item \code{name}: A descriptive name.
\item \code{description}: A brief description.
\item \code{template}: The template used to configure the integration.
\item \code{auth_type}: The OAuth flow used.
\item \code{config}: A list with integration-specific config fields.
}

Use \code{\link[=as.data.frame]{as.data.frame()}} or \code{\link[tibble:as_tibble]{tibble::as_tibble()}} to convert the result to a data frame with parsed types.
}
\description{
Retrieve OAuth integrations either from the Connect server or associated with a specific content item.

If \code{x} is a \code{Connect} object, this function lists all OAuth integrations on the server.
If \code{x} is a \code{Content} object, it returns the integrations associated with that content item.

You must have administrator or publisher privileges to use this function.
}
\examples{
\dontrun{
# From a Connect client
client <- connect()
integrations <- get_integrations(client)

# Filter or update specific ones
github_integration <- purrr::keep(integrations, \(x) x$template == "github")[[1]]

json_payload <- jsonlite::toJSON(list(
  description = "Updated Description",
  config = list(client_secret = "new-secret")
), auto_unbox = TRUE)

client$PATCH(
  paste0("v1/oauth/integrations/", github_integration$guid),
  body = json_payload
)

# From a Content item
content <- content_item(client, "12345678-90ab-cdef-1234-567890abcdef")
content_integrations <- get_integrations(content)

# Filter content integrations
snowflake_integrations <- purrr::keep(content_integrations, ~ .x$template == "snowflake")
}

}
\seealso{
\code{\link[=get_integration]{get_integration()}}, \code{\link[=set_integrations]{set_integrations()}}, \code{\link[=get_associations]{get_associations()}}

Other oauth integration functions: 
\code{\link{create_integration}()},
\code{\link{delete_integration}()},
\code{\link{get_associations}()},
\code{\link{get_integration}()},
\code{\link{set_integrations}()},
\code{\link{update_integration}()}
}
\concept{oauth integration functions}
