% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive_interval.R
\name{predictive_interval.conformal}
\alias{predictive_interval.conformal}
\title{Jackknife(+) predictive intervals}
\usage{
\method{predictive_interval}{conformal}(object, probs = 0.9, plus = NULL, local = TRUE, ...)
}
\arguments{
\item{object}{A fitted model which has been passed through \code{\link[=loo_conformal]{loo_conformal()}}}

\item{probs}{The coverage probabilities to calculate intervals for.
Empirically, the coverage rate of the constructed intervals will generally
match these probabilities, but the theoretical guarantee for a probability
of \eqn{1-\alpha} is only for coverage of at least \eqn{1-2\alpha}, and
only if \code{plus=TRUE} (below).}

\item{plus}{If \code{TRUE}, construct jackknife+ intervals, which have a
theoretical guarantee. These require higher computational costs, which
scale with both the number of training and prediction points. Defaults to
\code{TRUE} when both of these numbers are less than 500.}

\item{local}{If \code{TRUE} (the default), perform locally-weighted conformal
inference. This will inflate the width of the predictive intervals by a
constant amount across all predictions, preserving the relative amount of
uncertainty captured by the model. If \code{FALSE}, all predictive intervals
will have (nearly) the same width.}

\item{...}{Further arguments to the \link[rstantools:posterior_predict]{posterior_predict()}
method for \code{object}.}
}
\value{
A matrix with the number of rows matching the number of predictions.
Columns will be labeled with a percentile corresponding to \code{probs}; e.g. if
\code{probs=0.9} the columns will be \verb{5\%} and \verb{95\%}.
}
\description{
Construct finite-sample calibrated predictive intervals for Bayesian models,
following the approach in Barber et al. (2021). By default, the intervals will also reflect the
relative uncertainty in the Bayesian model, using the locally-weighted
conformal methods of Lei et al. (2018).
}
\examples{
\donttest{ # takes several seconds
if (requireNamespace("rstanarm", quietly=TRUE)) suppressWarnings({
    library(rstanarm)
    # fit a simple linear regression
    m = stan_glm(mpg ~ disp + cyl, data=mtcars,
        chains=1, iter=500,
        control=list(adapt_delta=0.999), refresh=0)

    m = loo_conformal(m)
    # make predictive intervals
    predictive_interval(m)
})
}

}
\references{
Barber, R. F., Candes, E. J., Ramdas, A., & Tibshirani, R. J. (2021).
Predictive inference with the jackknife+. \emph{The Annals of Statistics, 49}(1),
486-507.

Lei, J., G’Sell, M., Rinaldo, A., Tibshirani, R. J., & Wasserman, L. (2018).
Distribution-free predictive inference for regression. \emph{Journal of the
American Statistical Association, 113}(523), 1094-1111.
}
