% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configtype.R
\name{is.json.file}
\alias{is.json.file}
\title{Function to check wheather file is JSON format}
\usage{
is.json.file(
  file = Sys.getenv("R_CONFIGFILE_ACTIVE", "config.cfg"),
  json.file.debug = FALSE,
  ...
)
}
\arguments{
\item{file}{File name of configuration file to test. Defaults to the value of
the 'R_CONFIGFILE_ACTIVE' environment variable ('config.cfg' if the
variable does not exist and JSON/INI/YAML/TOML format only)}

\item{json.file.debug}{If TRUE, it will show error infomation when read JSON config,
default is FALSE}

\item{...}{Arguments for \code{\link{readLines}} and \code{\link[jsonlite]{fromJSON}}}
}
\value{
Logical indicating whether the specified configuration file is JSON format
}
\description{
Function to check wheather file is JSON format
}
\examples{
config.json <- system.file('extdata', 'config.json', package='configr')
config.ini <- system.file('extdata', 'config.ini', package='configr')
config.yaml <- system.file('extdata', 'config.yaml', package='configr')
config.toml <- system.file('extdata', 'config.toml', package='configr')
print(is.json.file(config.json))
print(is.json.file(config.ini))
print(is.json.file(config.yaml))
print(is.json.file(config.toml))
}
\seealso{
\code{\link{is.ini.file}},
\code{\link{is.yaml.file}},
\code{\link{is.toml.file}}
}
