% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get}
\alias{get}
\title{Read configuration values. Always use as \code{config::get()}.}
\usage{
get(
  value = NULL,
  config = Sys.getenv("R_CONFIG_ACTIVE", "default"),
  file = Sys.getenv("R_CONFIG_FILE", "config.yml"),
  use_parent = TRUE
)
}
\arguments{
\item{value}{Name of value (\code{NULL} to read all values)}

\item{config}{Name of configuration to read from. Defaults to
the value of the \code{R_CONFIG_ACTIVE} environment variable
("default" if the variable does not exist).}

\item{file}{Configuration file to read from (defaults to
\code{"config.yml"}). If the file isn't found at the location
specified then parent directories are searched for a file
of the same name.}

\item{use_parent}{\code{TRUE} to scan parent directories for
configuration files if the specified config file isn't found.}
}
\value{
The requested configuration value (or all values as
a list of \code{NULL} is passed for \code{value}).

A list, or vector, corresponding to the contents of the config file.
}
\description{
Read from the currently active configuration, retrieving either a
single named value or all values as a list.
}
\details{
For additional details see \url{https://rstudio.github.io/config/}.
}
\section{Warning - Do not attach the package using library(config)}{


We strongly recommend you use \code{config::get()} rather than attaching the
package using \code{library(config)}.

In fact, we strongly recommend you never use \code{library(config)}.

The underlying reason is that the \code{get()} and \code{merge()} functions in
\code{{config}} will mask these functions with the same names in base R.
}

\examples{

yaml <- "
default:
  trials: 5
  dataset: 'data-sampled.csv'

production:
  trials: 30
  dataset: 'data.csv'
"

get <- base::get



with_config(yaml, config::get())
with_config(yaml, config::get("trials"))

}
\seealso{
\code{\link[=is_active]{is_active()}}, \code{\link[=merge]{merge()}}
}
