% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialDesignFns.R
\name{getDataOrd}
\alias{getDataOrd}
\title{Generate ordinal data}
\usage{
getDataOrd(arm, resprate)
}
\arguments{
\item{arm}{Arm allocation for a single patient. Expects number in \emph{1,2,...,n} where \emph{n} is the number of treatment arms including control.}

\item{resprate}{Response rates for each arm. Expects a list of \emph{n} lists with the first list containing
probabilities for response level which correspond to the control arm.}
}
\value{
Returns an ordinal value corresponding to patient response.
}
\description{
Given an arm allocation and response rates, this function generates response on an ordinal scale.
}
\examples{
# for a three-point ordinal scale
response <- getDataOrd(1, list(control = c(0.3, 0.5, 0.7), treatment = (c(0.5, 0.3, 0.2))))
}
