% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_columns.R
\name{show_columns}
\alias{show_columns}
\title{Selects the variables to be printed}
\usage{
show_columns(x, columns, col_names)
}
\arguments{
\item{x}{A condformat object, typically created with \code{\link[=condformat]{condformat()}}}

\item{columns}{A character vector with column names to be to show. It can also be an expression
can be used that will be parsed according to \code{\link[tidyselect:language]{tidyselect::language()}}. See examples.}

\item{col_names}{Character vector with the column names for the selected columns}
}
\value{
The condformat object with the rule added
}
\description{
Keeps the variables you mention in the printed table.
Compared to \code{\link[dplyr:select]{dplyr::select()}}, show_columns does not remove the
columns from the data frame, so formatting rules can still depend
on them.
}
\examples{

data(iris)
x <- head(iris)

# Include some columns:
cf <- condformat(x) \%>\% show_columns(c(Sepal.Length, Sepal.Width, Species))
\dontrun{
print(cf)
}
cf <- condformat(x) \%>\% show_columns(c("Sepal.Length", "Sepal.Width", "Species"))
\dontrun{
print(cf)
}

# Rename columns:
cf <- condformat(x) \%>\%
  show_columns(c(Sepal.Length, Species),
               col_names = c("Length", "Spec."))
\dontrun{
print(cf)
}

# Exclude some columns:
cf <- condformat(x) \%>\% show_columns(c(-Petal.Length, -Petal.Width))
\dontrun{
print(cf)
}

cf <- condformat(x) \%>\% show_columns(c(starts_with("Petal"), Species))
\dontrun{
print(cf)
}

petal_width <- "Petal.Width"
cf <- condformat(x) \%>\% show_columns(!! petal_width)
\dontrun{
print(cf)
}

}
\seealso{
\code{\link[dplyr:select]{dplyr::select()}}
}
