% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequ.R
\name{concstats_simpson}
\alias{concstats_simpson}
\title{Gini-Simpson Index}
\usage{
concstats_simpson(x, na.rm = TRUE)
}
\arguments{
\item{x}{A non-negative numeric vector.}

\item{na.rm}{A logical vector that indicates whether \code{NA} values should
be excluded or not. Must be either \code{TRUE} or \code{FALSE}. The default
is \code{TRUE}.
If set to \code{FALSE} the computation yields \code{NA} if \code{NA} values
are present.}
}
\value{
A single numeric value in decimal form.
}
\description{
Gini-Simpson Index
}
\details{
\code{concstats_simpson} is the Gini-Simpson index, also known as
the Gini impurity (Gini's diversity index) in Machine Learning, Gibbs-Martin
index or Blau index in sociology and management studies. This index ranges
from (0, 1).
}
\examples{
# a vector of market shares
x <- c(0.4, 0.2, 0.25, 0.1, 0.05)
concstats_simpson(x)
# a vector with NA values
x <- c(0.4, 0.2, 0.25, 0.1, 0.05, NA)
concstats_simpson(x, na.rm = FALSE)

}
\references{
Simpson, E. H. (1949). "Measurement of Diversity", \emph{Nature},
163, 688.

Jost, L. (2006). "Entropy and Diversity". \emph{Oikos}, 113(2),
363-375.
}
