% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp.R
\name{concstats_comp}
\alias{concstats_comp}
\title{Group of Concentration Measures}
\usage{
concstats_comp(x, normalized = FALSE, type = c("hhi", "hhi_d", "hhi_min",
 "dom", "sten", "all"), na.rm = TRUE, digits = NULL)
}
\arguments{
\item{x}{A non-negative numeric vector.}

\item{normalized}{Logical. Argument specifying whether or not a normalized
value is required. Ranges from (0, 1) and often used for comparison over
time. Must be either \code{TRUE} or \code{FALSE}. The default
is \code{FALSE}.}

\item{type}{A character string of the measure to be calculated,
can be abbreviated with the first letter. Defaults to "hhi". Input is not
case-sensitive.}

\item{na.rm}{A logical vector that indicates whether \code{NA} values should
be excluded or not. If set to \code{FALSE} the computation yields \code{NA}
if vector contains \code{NA} values.
Must be either \code{TRUE} or \code{FALSE}. Defaults to \code{TRUE}.}

\item{digits}{A non-null value for digits specifies the minimum number of
significant digits to be printed in values. The default is \code{NULL} and
will use base R print option.  Significant digits defaults to 7.}
}
\value{
A single numeric measure in decimal form or \verb{data frame}.
}
\description{
A set of different concentration measures.
}
\details{
\code{concstats_comp} is a wrapper for the proposed concentration measures
\code{\link[=concstats_hhi]{concstats_hhi()}}, \code{\link[=concstats_hhi_d]{concstats_hhi_d()}}, \code{\link[=concstats_dom]{concstats_dom()}},
\code{\link[=concstats_hhi_min]{concstats_hhi_min()}}, \code{\link[=concstats_sten]{concstats_sten()}}, \code{\link[=concstats_all_comp]{concstats_all_comp()}}.
If no measure is specified "hhi" will be the default.
\code{concstats_hhi}, can be calculated individually as a normalized
measure changing the default setting to \code{TRUE}.
\code{concstats_all_comp} computes all measures in a one step procedure.
For more details or references please see the help page of the respective
function.
}
\note{
The vector of market shares should be in a decimal form corresponding
to total shares of individual firms/units. The vector should sum up to 1.
}
\examples{
# a vector of market shares
x <- c(0.35, 0.4, 0.05, 0.1, 0.06, 0.04)
# the Herfindahl-Hirschman index of the vector
concstats_comp(x, type = "hhi")
# individual measure
concstats_sten(x)
# complete group measures
concstats_comp(x, type = "all", digits = 2)

}
\seealso{
\code{\link[=concstats_concstats]{concstats_concstats()}}, \code{\link[=concstats_mstruct]{concstats_mstruct()}}, \code{\link[=concstats_inequ]{concstats_inequ()}}
}
