% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp.R
\name{concstats_all_comp}
\alias{concstats_all_comp}
\title{A wrapper for the proposed concentration measures}
\usage{
concstats_all_comp(x, normalized = FALSE, na.rm = TRUE, digits = NULL)
}
\arguments{
\item{x}{A non-negative numeric vector.}

\item{normalized}{Logical. Argument specifying whether or not a normalized
value is required. Must be either \code{TRUE} or \code{FALSE}. Defaults to
\code{FALSE}.}

\item{na.rm}{A logical vector that indicates whether \code{NA} values should
be excluded or not. Must be either \code{TRUE} or \code{FALSE}. The default
is \code{TRUE}.
If set to \code{FALSE} the computation yields \code{NA} if \code{NA} values
are present.}

\item{digits}{A non-null value for digits specifies the minimum number of
significant digits to be printed in values. The default is \code{NULL} and
will use base R print option. Significant digits defaults to 7.}
}
\value{
A \code{data.frame}.
}
\description{
A wrapper for the proposed concentration measures
}
\details{
\code{concstats_all_comp} returns all proposed group measures in a one step
procedure with default settings if not otherwise specified.
}
\examples{
# a vector of market shares
x <- c(0.35, 0.4, 0.05, 0.1, 0.06, 0.04)
concstats_all_comp(x, digits = 2)
}
\seealso{
\code{\link[=concstats_all_mstruct]{concstats_all_mstruct()}}, \code{\link[=concstats_all_inequ]{concstats_all_inequ()}}
}
