% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_kp.R
\name{make_kp}
\alias{make_kp}
\alias{make_kp,numeric,numeric,numeric,numeric,numeric-method}
\alias{make_kp,numeric,numeric,missing,numeric,numeric-method}
\title{Generating a kp network}
\usage{
make_kp(n, np, pb, k, p)

\S4method{make_kp}{numeric,numeric,numeric,numeric,numeric}(n, np, pb, k, p)

\S4method{make_kp}{numeric,numeric,missing,numeric,numeric}(n, np, pb, k, p)
}
\arguments{
\item{n}{Number of vertices (population size)}

\item{np}{numeric vector setting ids for the newborn (i.e. which individual will be replaced with a new one) and a parent(s). Length 2 or 3. If you want to randomly select an id for the newborn (first value) and parents (second and third value), simply use c(0,0) or c(0,0,0).}

\item{pb}{Probability to connect to parent (default is 1)}

\item{k}{Degree (number of connections a new individual will form)}

\item{p}{Maximum proportion of k that will be connections to neighbours of the parent. The complimentary k*(1-p) connections will be formed with random other individuals}
}
\value{
Returns an unweighed (binary) adjacency matrix, where each cell represents the presence (1) or absence (0) of an interaction between the row and the column individual.
}
\description{
This function ...
}
\details{
It is important to note that ... P is a maximum value, say an individual wants to have 10 connections and P=0.5, i.e. it wants 5 connections to the neighbours of its parent but the parent only has 4 then it will only inherit those 4.
}
\examples{
make_kp(n = 10, np = c(0,0), pb = 1, k = 4, p = .5)
}
