% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{snooker_events}
\alias{snooker_events}
\title{Snooker events}
\format{A \link[tibble:tibble]{tibble} with one row per event and the following
columns:
\itemize{
\item \strong{id} \verb{<int>} : Event identifier in snooker.org database (used in \code{eventId}
column of \link{snooker_matches}).
\item \strong{season} \verb{<int>} : Season identifier (by the year of season start).
\item \strong{name} \verb{<chr>} : Event name.
\item \strong{startDate} \verb{<dttm>} : Start date of event.
\item \strong{endDate} \verb{<dttm>} : End date of event.
\item \strong{sponsor} \verb{<chr>} : Event sponsor name.
\item \strong{type} \verb{<chr>} : Event type ("Invitational", "Qualifying", or "Ranking").
\item \strong{venue} \verb{<chr>} : Venue name event was played.
\item \strong{city} \verb{<chr>} : City name event was played.
\item \strong{country} \verb{<chr>} : Country name event was played.
}}
\usage{
snooker_events
}
\description{
Data set describing snooker events in seasons 2016/2017 and 2017/2018.
}
\details{
Data is taken from snooker.org (http://www.snooker.org/) API.

This data set has information about events that have all following qualities:
\itemize{
\item It has "Invitational", "Qualifying", or "Ranking" type.
\item It describes traditional snooker (not 6 Red or Power Snooker) between
individual players (not teams).
\item Both genders can take part (not only men or women).
\item Players of all ages can take part (not only seniors or under 21).
\item It is not "Shoot-Out" as those events are treated differently in
snooker.org database.
}
}
\seealso{
\link[=snooker_players]{Snooker players},
\link[=snooker_matches]{snooker matches}
}
\keyword{datasets}
