% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mr_2sls.R
\name{mr_2sls}
\alias{mr_2sls}
\title{Mendelian Randomization Two-Stage Least Square (2SLS) method with external PGS}
\usage{
mr_2sls(
  df = NULL,
  prs_col = "SCORESUM",
  exposure_col = NA,
  outcome_col = NA,
  scale = TRUE,
  verbose = TRUE,
  log = ""
)
}
\arguments{
\item{df}{a dataframe with individuals on each row, and at least the following
columns:
\itemize{
\item one ID column,
\item one PGS column, with numerical continuous values following a normal distribution,
\item two Phenotype columns (for Exposure and Outcome), can be numeric (Continuous Phenotype), character, boolean or factors (Discrete Phenotype)
}}

\item{prs_col}{a character specifying the PGS column name}

\item{exposure_col}{a character specifying the Exposure (Phenotype) column name}

\item{outcome_col}{a character specifying the Outcome (Phenotype) column name}

\item{scale}{a boolean specifying if scaling of PGS should be done before testing}

\item{verbose}{a boolean (TRUE by default) to write in the console/log messages.}

\item{log}{a connection, or a character string naming the file to print to.
If "" (by default), it prints to the standard output connection, the console unless redirected by sink.}
}
\value{
return a data frame with the Mendelian Randomization association
result using 2SLS method with the following columns:
\itemize{
\item PGS: the name of the PGS used
\item Exposure: the name of Phenotype used as Exposure
\item Outcome: the name of Phenotype used as Outcome
\item Method: the MR method used (here 2SLS)
\item N_cases: if Phenotype_type is Cases/Controls, the number of cases
\item N_controls: if Phenotype_type is Cases/Controls, the number of controls
\item N: the number of individuals/samples
\item MR_estimate: the MR estimate (beta) using the ratio method
\item SE: the associated standard error (second order)
\item F_stat: the F-statistic of the Exposure ~ PGS association
}
}
\description{
\code{mr_2sls()} takes a distribution of PGS, an Exposure (Phenotype), an Outcome (Phenotype).
Returns a data frame of the result of the Mendelian Randomization 2SLS methods using PGS
}
\examples{
result <- mr_2sls(
  df = comorbidData,
  prs_col = "ldl_PGS",
  exposure_col = "log_ldl",
  outcome_col = "bmi",
  scale = TRUE
)
print(result)

}
