% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artifact.R
\name{create_artifact}
\alias{create_artifact}
\title{Create Comet Artifact object}
\usage{
create_artifact(
  artifact_name,
  artifact_type,
  artifact_version = NULL,
  aliases = NULL,
  metadata = NULL,
  version_tags = NULL
)
}
\arguments{
\item{artifact_name}{(Required) Artifact name.}

\item{artifact_type}{(Required) The artifact type, for example 'dataset'.}

\item{artifact_version}{The version number to create. If not provided,
a new version number will be created automatically.}

\item{aliases}{List of aliases. Some aliases to attach to the future Artifact
Version. The aliases list is normalized to remove duplicates.}

\item{metadata}{Some additional meta-data to attach to the future Artifact Version.}

\item{version_tags}{List of tags to be attached to the future Artifact Version.}
}
\description{
Creates new \code{Artifact} object with provided parameters. After that,
the \code{Artifact} object can be used to save assets and can be logged
with an \code{\link{Experiment}}.
}
\examples{
\dontrun{
library(cometr)
# Assuming you have COMET_API_KEY, COMET_WORKSPACE, COMET_PROJECT_NAME variables define
exp <- create_experiment()

# Create a Comet Artifact
artifact <- create_artifact(artifact_name = "Artifact-Name", artifact_type = "Artifact-Type")
artifact$add("local-file")

exp$log_artifact(artifact)
exp$stop()
}

}
