% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artifact.R
\name{ArtifactAsset}
\alias{ArtifactAsset}
\title{An Artifact Asset object}
\description{
The \code{ArtifactAsset} represent local or remote asset added to an
\code{\link{Artifact}} object but not yet uploaded
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ArtifactAsset-new}{\code{ArtifactAsset$new()}}
\item \href{#method-ArtifactAsset-get_local_path}{\code{ArtifactAsset$get_local_path()}}
\item \href{#method-ArtifactAsset-get_logical_path}{\code{ArtifactAsset$get_logical_path()}}
\item \href{#method-ArtifactAsset-is_remote}{\code{ArtifactAsset$is_remote()}}
\item \href{#method-ArtifactAsset-has_overwrite}{\code{ArtifactAsset$has_overwrite()}}
\item \href{#method-ArtifactAsset-get_size}{\code{ArtifactAsset$get_size()}}
\item \href{#method-ArtifactAsset-get_link}{\code{ArtifactAsset$get_link()}}
\item \href{#method-ArtifactAsset-get_metadata}{\code{ArtifactAsset$get_metadata()}}
\item \href{#method-ArtifactAsset-get_asset_type}{\code{ArtifactAsset$get_asset_type()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArtifactAsset-new"></a>}}
\if{latex}{\out{\hypertarget{method-ArtifactAsset-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \code{ArtifactAsset} object with provided parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArtifactAsset$new(
  logical_path,
  overwrite = FALSE,
  remote = FALSE,
  size = 0,
  link = NULL,
  local_path = NULL,
  metadata = NULL,
  asset_type = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{logical_path}}{the logical file name.}

\item{\code{overwrite}}{If \code{\link{TRUE}} will overwrite all existing assets with the same name.}

\item{\code{remote}}{Is the asset a remote asset or not.}

\item{\code{size}}{The size if the asset of a non-remote asset.}

\item{\code{link}}{The remote link if the asset is remote.}

\item{\code{local_path}}{The local file path if the asset is non-remote.}

\item{\code{metadata}}{The metadata to be associated with the asset.}

\item{\code{asset_type}}{The type of asset.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArtifactAsset-get_local_path"></a>}}
\if{latex}{\out{\hypertarget{method-ArtifactAsset-get_local_path}{}}}
\subsection{Method \code{get_local_path()}}{
Asset local path if the asset is non-remote
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArtifactAsset$get_local_path()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArtifactAsset-get_logical_path"></a>}}
\if{latex}{\out{\hypertarget{method-ArtifactAsset-get_logical_path}{}}}
\subsection{Method \code{get_logical_path()}}{
Asset logical file name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArtifactAsset$get_logical_path()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArtifactAsset-is_remote"></a>}}
\if{latex}{\out{\hypertarget{method-ArtifactAsset-is_remote}{}}}
\subsection{Method \code{is_remote()}}{
Is the asset a remote asset or not
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArtifactAsset$is_remote()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArtifactAsset-has_overwrite"></a>}}
\if{latex}{\out{\hypertarget{method-ArtifactAsset-has_overwrite}{}}}
\subsection{Method \code{has_overwrite()}}{
Is the asset will overwrite existing asset with the same name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArtifactAsset$has_overwrite()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArtifactAsset-get_size"></a>}}
\if{latex}{\out{\hypertarget{method-ArtifactAsset-get_size}{}}}
\subsection{Method \code{get_size()}}{
Asset size if the asset is a non-remote asset
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArtifactAsset$get_size()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArtifactAsset-get_link"></a>}}
\if{latex}{\out{\hypertarget{method-ArtifactAsset-get_link}{}}}
\subsection{Method \code{get_link()}}{
Asset remote link if the asset is remote or NULL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArtifactAsset$get_link()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArtifactAsset-get_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-ArtifactAsset-get_metadata}{}}}
\subsection{Method \code{get_metadata()}}{
Asset metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArtifactAsset$get_metadata()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArtifactAsset-get_asset_type"></a>}}
\if{latex}{\out{\hypertarget{method-ArtifactAsset-get_asset_type}{}}}
\subsection{Method \code{get_asset_type()}}{
Asset type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArtifactAsset$get_asset_type()}\if{html}{\out{</div>}}
}

}
}
