% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPalette.R
\name{plotPalette}
\alias{plotPalette}
\title{plotPalette}
\usage{
plotPalette(df, color_col)
}
\arguments{
\item{df}{A vector of colours or a data frame containing a column with colors in hexadecimal format.}

\item{color_col}{A character string representing the name of the column containing the colors.}
}
\value{
A ggplot2 plot object displaying the color palette.
}
\description{
Plot a color palette from a data frame.
This function takes a vector of colours or a
data frame with a column of colors and plots the colors as a color palette.
}
\examples{
# Create a sample data frame with colors
colors_df <- data.frame(
  color = c("#FF0000", "#00FF00", "#0000FF", "#FFFF00", "#FF00FF")
)

# Plot the color palette with default bar height
plotPalette(colors_df, "color")

}
