% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_class.R, R/color_plane.R
\docType{class}
\name{DiscreteColorPlane-class}
\alias{DiscreteColorPlane-class}
\alias{DiscreteColorPlane}
\title{DiscreteColorPlane}
\usage{
DiscreteColorPlane(lookup)
}
\arguments{
\item{lookup}{a "lookup table", which is a named list mapping discrete values to hex colors}
}
\value{
a new \code{\linkS4class{DiscreteColorPlane}} instance
}
\description{
DiscreteColorPlane constructor taking list with names mapping to color values in hex representation.
This object is used when one has a one to one mapping between discrete set of strings/values to discrete set of colors.
}
\section{Slots}{

\describe{
\item{\code{lookup}}{a lookup table mapping values to hex colors}
}}

\examples{

lookup <- as.list(col2hex(c("red", "blue", "green")))
names(lookup) <- c("a", "b", "c")
cp <- DiscreteColorPlane(lookup)

values <- c("a", "b", "c", "a", "c")
}
