% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_arg_max_cor.R
\name{validate_arg_max_cor}
\alias{validate_arg_max_cor}
\title{Check and constrain argument \code{max_cor}}
\usage{
validate_arg_max_cor(max_cor = NULL, quiet = FALSE, function_name = NULL)
}
\arguments{
\item{max_cor}{(optional; numeric or NULL) Maximum correlation allowed between pairs of \code{predictors}. Valid values are between 0.01 and 0.99, and recommended values are between 0.5 (strict) and 0.9 (permissive). Default: 0.7}

\item{quiet}{(optional; logical) If FALSE, messages are printed. Default: FALSE.}

\item{function_name}{(optional, character string) Name of the function performing the argument check. Default: NULL}
}
\value{
numeric or NULL
}
\description{
Check and constrain argument \code{max_cor}
}
\examples{
x <- validate_arg_max_cor(
  max_cor = 1.5, #wrong value
  quiet = FALSE
)

x
attributes(x)$validated
}
\seealso{
Other argument_validation: 
\code{\link{drop_geometry_column}()},
\code{\link{validate_arg_df}()},
\code{\link{validate_arg_df_not_null}()},
\code{\link{validate_arg_encoding_method}()},
\code{\link{validate_arg_f}()},
\code{\link{validate_arg_function_name}()},
\code{\link{validate_arg_max_vif}()},
\code{\link{validate_arg_predictors}()},
\code{\link{validate_arg_preference_order}()},
\code{\link{validate_arg_quiet}()},
\code{\link{validate_arg_responses}()}
}
\concept{argument_validation}
