% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_logical_variables.R
\name{identify_logical_variables}
\alias{identify_logical_variables}
\title{Find logical variables in a dataframe}
\usage{
identify_logical_variables(
  df = NULL,
  responses = NULL,
  predictors = NULL,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{df}{(required; dataframe, tibble, or sf) A dataframe with responses
(optional) and predictors. Must have at least 10 rows for pairwise
correlation analysis, and \code{10 * (length(predictors) - 1)} for VIF.
Default: NULL.}

\item{responses}{(optional; character, character vector, or NULL) Name of
one or several response variables in \code{df}. Default: NULL.}

\item{predictors}{(required, character vector) Names of the predictors to identify. Default: NULL}

\item{quiet}{(optional; logical) If FALSE, messages are printed. Default: FALSE.}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
list:
\itemize{
\item \code{valid}: character vector with valid logical predictor names.
\item \code{invalid}: character vector with invalid logical predictor names.
}
}
\description{
Identifies logical predictors and excludes those with constant values.
}
\examples{

data(vi_smol, vi_predictors)

#invalid logical
vi_smol$logical_invalid <- TRUE

#valid logical
vi_smol$logical_valid <- sample(
  x = c(TRUE, FALSE),
  size = nrow(vi_smol),
  replace = TRUE
)

x <- identify_logical_variables(
  df = vi_smol,
  predictors = c(
    vi_predictors,
    "logical_invalid",
    "logical_valid"
  )
)

x$valid
x$invalid

}
\seealso{
Other data_types: 
\code{\link{identify_categorical_variables}()},
\code{\link{identify_numeric_variables}()},
\code{\link{identify_response_type}()},
\code{\link{identify_valid_variables}()},
\code{\link{identify_zero_variance_variables}()}
}
\author{
Blas M. Benito, PhD
}
\concept{data_types}
