% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tally.r
\name{tally}
\alias{tally}
\alias{tally_results}
\alias{tally_errors}
\alias{tally_warnings}
\alias{tally_messages}
\alias{tally_output}
\title{Determine how many elements contain a type of mapped side effect.}
\usage{
tally_results(x)

tally_errors(x)

tally_warnings(x)

tally_messages(x)

tally_output(x)
}
\arguments{
\item{x}{A ``safely_mapped\code{or}quietly_mapped` list to tally.}
}
\value{
An integer vector of length 1.
}
\description{
Unlike \code{\link[=summary]{summary()}}, the tally functions return counts of individual
types of side effects. This makes them easy to use with
\code{\link[dplyr:summarise]{dplyr::summarise()}}.
}
\details{
Importantly, the tally functions tell you how many \emph{elements} returned a type
of side effect, not how many \emph{side effects} were returned. Some list elements
might return more than one warning, for example, and these are not counted
separately.
}
\examples{

library(tibble)
library(dplyr)
library(tidyr)
library(collateral)

list("a", 10, 100) \%>\% map_safely(log) \%>\% tally_errors()
list(5, -12, 103) \%>\% map_quietly(log) \%>\% tally_warnings()

# if you're working with list-columns, the tally functions are useful
# in conjunction with dplyr::summarise()
mtcars \%>\%
  rownames_to_column(var = "car") \%>\%
  as_tibble() \%>\%
  select(car, cyl, disp, wt) \%>\%
  # spike some rows in cyl == 4 to make them fail
  mutate(wt = dplyr::case_when(
    wt < 2 ~ -wt,
    TRUE ~ wt)) \%>\%
  # nest and do some operations quietly()
  nest(data = -cyl) \%>\%
  mutate(qlog = map_quietly(data, ~ log(.$wt))) \%>\%
  summarise(
    num_results = tally_results(qlog),
    num_warnings = tally_warnings(qlog))

}
