% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/currencies.R
\name{get_crypto_listings}
\alias{get_crypto_listings}
\title{Get latest/historical market data}
\usage{
get_crypto_listings(currency = "USD", latest = TRUE, ...)
}
\arguments{
\item{currency}{currency code - Default is 'USD'}

\item{latest}{If `TRUE` (default), only the latest data is retrieved,
otherwise historical data is returned. (NOTE: Historic Data require higher API rights)}

\item{...}{Further arguments can be passed to historical data. Further information
can be found in the \href{https://coinmarketcap.com/api/documentation/v1/#operation/getV1GlobalmetricsQuotesHistorical}{API documentation}}
}
\value{
A dataframe of top Cryptocurrencies with current or historic market data
}
\description{
Get a paginated list of all active cryptocurrencies with latest market data.
The default "market_cap" sort returns cryptocurrency in order of CoinMarketCap's
market cap rank (as outlined in our methodology) but you may configure this call
to order by another market ranking field.
Use the "convert" option to return market values in multiple fiat and
cryptocurrency conversions in the same call.
}
\examples{
\dontrun{
get_crypto_listings('EUR')
get_crypto_listings('GBP')
get_crypto_listings('GBP', latest=F, start=1,
                    date=Sys.Date()-20, limit=10, sort="price", sort_dir="asc")
}
}
\references{
\href{https://coinmarketcap.com/api/documentation/v1/#operation/getV1CryptocurrencyListingsLatest}{API documentation}
}
\seealso{
Other Cryptocurrencies: 
\code{\link{get_crypto_map}()},
\code{\link{get_crypto_marketpairs}()},
\code{\link{get_crypto_meta}()},
\code{\link{get_crypto_ohlcv}()},
\code{\link{get_crypto_quotes}()},
\code{\link{get_marketcap_ticker_all}()},
\code{\link{get_valid_currencies}()}
}
\concept{Cryptocurrencies}
