% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumstat_nucleotide_div.R
\name{sumstat_nucleotide_div}
\alias{sumstat_nucleotide_div}
\title{Summary Statistic: Nucleotide Diversity}
\usage{
sumstat_nucleotide_div(name = "pi", population = 1, transformation = identity)
}
\arguments{
\item{name}{The name of the summary statistic. When simulating a model,
the value of the statistics are written to an entry of the returned list
with this name. Summary statistic names must be unique in a model.}

\item{population}{The population for which the statistic is calculated.
Can also be "all" to calculate it from all populations. Default is population 1.}

\item{transformation}{An optional function for transforming the results
of the statistic. If specified, the results of the transformation are
returned instead of the original values.}
}
\value{
On simulation, this returns a vector with the value of pi for
each locus.
}
\description{
The summary statistic calculates the nucleotide diversity (\eqn{\pi})
per locus, which is the mean number of pairwise difference for
two individuals. It is a commonly used estimator for the scaled
mutation rate \eqn{\theta}.
}
\details{
The nucleotide diversity was introduced by

Nei and Li (1979). "Mathematical Model for Studying Genetic Variation in
Terms of Restriction Endonucleases". PNAS 76 (10): 5269-73.
doi:10.1073/pnas.76.10.5269.
}
\examples{
model <- coal_model(5, 2) +
  feat_mutation(5) +
  sumstat_nucleotide_div()
stats <- simulate(model)
print(stats$pi)
}
\seealso{
To create a demographic model: \code{\link{coal_model}}

To calculate this statistic from data: \code{\link{calc_sumstats_from_data}}

Other summary statistics: 
\code{\link{sumstat_dna}()},
\code{\link{sumstat_file}()},
\code{\link{sumstat_four_gamete}()},
\code{\link{sumstat_ihh}()},
\code{\link{sumstat_jsfs}()},
\code{\link{sumstat_mcmf}()},
\code{\link{sumstat_omega}()},
\code{\link{sumstat_seg_sites}()},
\code{\link{sumstat_sfs}()},
\code{\link{sumstat_tajimas_d}()},
\code{\link{sumstat_trees}()}
}
\concept{summary statistics}
