% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigma2_cnb.R
\name{sigma2_cnb}
\alias{sigma2_cnb}
\title{Variance of Conditional Negative Binomial}
\usage{
sigma2_cnb(D, r1, r2, lambda)
}
\arguments{
\item{D}{a positive integer.}

\item{r1}{a positive value.}

\item{r2}{a positive value.}

\item{lambda}{a positive value.}
}
\value{
V(X | X + Y = D).
}
\description{
Function calculating variance of the conditional distribution of X given X + Y = D,
where X ~ NB(r1, p1) and Y ~ NB(r2, p2) are drawn from two negative binomials,
independent of each other,
and assuming p1/p2 = lambda.
}
\details{
Need to specify full list of arguments, as default values have not been set.
}
\examples{
sigma2_cnb(7, 2, 0.4, 0.6)

}
\seealso{
\code{\link{mu_cnb}}
}
\author{
Xiaotian Zhu, \email{xiaotian.zhu.psualum@gmail.com}
}
