% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmps_plot.R
\name{cmps_signature_plot}
\alias{cmps_signature_plot}
\title{Plot reference signature and comparison signature based on the results of CMPS algorithm}
\usage{
cmps_signature_plot(cmps_result, add_background = TRUE)
}
\arguments{
\item{cmps_result}{a list generated by \code{extract_feature_cmps}. \code{cmps_result} is required to have
the following names: \code{parameters}, \code{congruent_seg}, \code{congruent_pos}, \code{segments}, \code{ccp_list}. So
\code{include = "full_result"} is recommended when computing \code{cmps_result}}

\item{add_background}{boolean; whether or not to add zebra-striped background under each basis
segment; default is TRUE}
}
\value{
a list
\itemize{
\item \code{segment_shift_plot}: a plot object generated by ggplot2. In this plot only basis segments that are
congruent matching profile segments (CMPS) are plotted along with the comparison profile; each basis
segment is shifted to the position where it obtains either a consistent correlation peak or a
cross-correlation peak closest to the congruent registration position
\item \code{signature_shift_plot}:  a plot object generated by ggplot2. In this plot both the reference
signature and the comparison signature are plotted, and CMPS are highlighted. The alignment of the
two signatures is achieved by shifting the reference signature to the congruent registration position.
\item \code{seg_shift}: a data.frame. This data frame shows which basis segments are plotted (are CMPS) and
the units by which each segment shifted when plotting \code{segment_shift_plot}
\item \code{sig_shift}: a numeric value. The number of units by which the reference signature shifted
when plotting \code{signature_shift_plot}
}
}
\description{
This function aligns two signatures and shows which basis segments find the congruent
registration position.
}
\examples{
library(cmpsR)

data("bullets")
land2_3 <- bullets$sigs[bullets$bulletland == "2-3"][[1]]
land1_2 <- bullets$sigs[bullets$bulletland == "1-2"][[1]]

# compute cmps

# algorithm with multi-peak insepction at three different segment scales
cmps_with_multi_scale <- extract_feature_cmps(land2_3$sig, land1_2$sig, include = "full_result" )

# generate plots using cmps_signature_plot
sig_plot <- cmps_signature_plot(cmps_with_multi_scale)
}
