\name{urticaria_activity_score}
\alias{urticaria_activity_score}
\title{
Urticaria Activity Score (UAS)
}
\description{
Calculates the daily Urticaria Activity Score (UAS) to assess the disease activity of chronic spontaneous urticaria. The score is the sum of the daily wheal score and the daily pruritus score.
}
\usage{
urticaria_activity_score(wheals_score, pruritus_score)
}
\arguments{
  \item{wheals_score}{
Numeric (0-3). Assessment of number of wheals.
0: None.
1: Mild (< 20 wheals/24h).
2: Moderate (20-50 wheals/24h).
3: Intense (> 50 wheals/24h or large confluent areas of wheals).
}
  \item{pruritus_score}{
Numeric (0-3). Assessment of intensity of itch.
0: None.
1: Mild (Present but not annoying or troublesome).
2: Moderate (Troublesome but does not interfere with normal daily activity or sleep).
3: Intense (Severe, sufficiently troublesome to interfere with normal daily activity or sleep).
}
}
\value{
A list containing:
\item{UAS_Daily_Score}{The calculated daily score (Range 0-6).}
\item{Interpretation}{Context for the score range.}
}
\references{
Zuberbier T, Aberer W, Asero R, et al. The EAACI/GA²LEN/EDF/WAO guideline for the definition, classification, diagnosis and management of urticaria. Allergy. 2018;73(7):1393-1414. doi:10.1111/all.13397
}
\examples{

# Example 1: Moderate Disease
# Moderate wheals (2), Mild itch (1)
# Score = 3
urticaria_activity_score(2, 1)

# Example 2: Severe Disease
# Intense wheals (3), Intense itch (3)
# Score = 6
urticaria_activity_score(3, 3)
}
