\name{tash_score_trauma}
\alias{tash_score_trauma}
\title{
Trauma Associated Severe Hemorrhage (TASH) Score
}
\description{
Calculates the TASH Score to predict the probability of needing a massive transfusion (>= 10 units of packed red blood cells) in trauma patients. The score uses seven independent variables available early in the trauma room.
}
\usage{
tash_score_trauma(systolic_bp, hemoglobin, fast_positive, complex_fractures,
                  heart_rate, base_excess, sex)
}
\arguments{
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg.
<100: +4 pts.
100-120: +1 pt.
>120: 0 pts.
}
  \item{hemoglobin}{
Numeric. Hemoglobin level in g/dL.
<7: +6 pts.
7-<9: +4 pts.
9-<11: +3 pts.
11-<12: +2 pts.
>=12: 0 pts.
}
  \item{fast_positive}{
Numeric (0 or 1). Positive Focused Assessment with Sonography for Trauma (FAST) for intra-abdominal fluid. (1 = Yes, +3 pts).
}
  \item{complex_fractures}{
Numeric (0 or 1). Presence of clinically unstable pelvic fracture or open/dislocated femur fracture. (1 = Yes, +3 pts).
}
  \item{heart_rate}{
Numeric. Heart rate in bpm. (>120: +2 pts).
}
  \item{base_excess}{
Numeric. Base excess in mmol/L.
<-10: +4 pts.
-10 to <-6: +3 pts.
-6 to <-2: +1 pt.
>=-2: 0 pts.
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Male: +1 pt).
}
}
\value{
A list containing:
\item{TASH_Score}{The calculated total score (Range 0-28).}
\item{Probability_Massive_Transfusion}{The estimated probability of requiring massive transfusion based on the score.}
}
\references{
Yücel N, Lefering R, Maegele M, et al. Trauma Associated Severe Hemorrhage (TASH)-Score: probability of mass transfusion as surrogate for life threatening hemorrhage after multiple trauma. J Trauma. 2006;60(6):1228-1236. doi:10.1097/01.ta.0000220386.84012.bf
}
\examples{

# Example 1: High Risk
# SBP 90 (4), Hb 8 (4), FAST+ (3), Pelvic Fx (3), HR 130 (2), BE -8 (3), Male (1)
# Score = 20
tash_score_trauma(90, 8, 1, 1, 130, -8, "male")

# Example 2: Low Risk
# SBP 130 (0), Hb 13 (0), FAST- (0), No Fx (0), HR 90 (0), BE 0 (0), Female (0)
# Score = 0
tash_score_trauma(130, 13, 0, 0, 90, 0, "female")
}
