\name{score_2helps2b}
\alias{score_2helps2b}
\title{
2HELPS2B Score for Inpatient Seizure Risk
}
\description{
Calculates the 2HELPS2B score to estimate the risk of seizures in hospitalized patients undergoing continuous EEG (cEEG). Validated by Struck et al., this score uses clinical history and specific EEG findings (usually from the first hour of recording) to stratify patients into low, medium, or high risk, guiding the duration of monitoring.
}
\usage{
score_2helps2b(frequency_gt_2hz, sporadic_discharges, lpd_lrda_bipd,
               plus_features, prior_seizure, bird)
}
\arguments{
  \item{frequency_gt_2hz}{
Numeric (0 or 1). Presence of any periodic or rhythmic pattern with frequency > 2.0 Hz (excluding Generalized Rhythmic Delta Activity/GRDA). (+1 point).
}
  \item{sporadic_discharges}{
Numeric (0 or 1). Presence of independent sporadic epileptiform discharges. (+1 point).
}
  \item{lpd_lrda_bipd}{
Numeric (0 or 1). Presence of Lateralized Periodic Discharges (LPDs), Lateralized Rhythmic Delta Activity (LRDA), or Bilateral Independent Periodic Discharges (BIPDs). (+1 point).
}
  \item{plus_features}{
Numeric (0 or 1). Presence of "Plus" features (superimposed rhythmic, sharp, or fast activity). (+1 point).
}
  \item{prior_seizure}{
Numeric (0 or 1). History of prior seizure (acute or remote). (+1 point).
}
  \item{bird}{
Numeric (0 or 1). Presence of Brief Potentially Ictal Rhythmic Discharges (BIRDs). (+2 points).
}
}
\value{
A list containing:
\item{Score}{The calculated 2HELPS2B score (Range 0-7).}
\item{Risk_Category}{Risk classification (Low, Medium, or High).}
\item{Seizure_Risk_Percentage}{Estimated probability of seizure activity (e.g., "5\%", "12\%", "27\%", etc.).}
\item{Recommended_Monitoring}{Suggested duration of cEEG based on risk (1 hour, 12 hours, or 24+ hours).}
}
\references{
Struck AF, et al. Assessment of the Validity of the 2HELPS2B Score for Inpatient Seizure Risk Prediction. JAMA Neurol. 2020;77(4):500-507. doi:10.1001/jamaneurol.2019.4656
}
\examples{

# Example 1: High Risk Patient
# LPDs present (+1), Plus features (+1), Prior seizure (+1) = Score 3
score_2helps2b(0, 0, 1, 1, 1, 0)

# Example 2: Low Risk Patient
# No abnormalities, no history of seizure = Score 0
score_2helps2b(0, 0, 0, 0, 0, 0)

# Example 3: Very High Risk
# BIRDs present (+2), Frequency > 2Hz (+1) = Score 3
score_2helps2b(1, 0, 0, 0, 0, 1)
}
