\name{schwab_england_adl_scale}
\alias{schwab_england_adl_scale}
\title{
Schwab and England Activities of Daily Living (ADL) Scale
}
\description{
Retrieves the clinical description for the Schwab and England ADL Scale score. This scale assesses the ability of patients with Parkinson's disease or other movement disorders to perform daily activities independently. Scores range from 100\% (completely independent) to 0\% (vegetative functions not functioning).
}
\usage{
schwab_england_adl_scale(score_percent)
}
\arguments{
  \item{score_percent}{
Numeric. The assessed score as a percentage. Must be a multiple of 10 between 0 and 100.
}
}
\value{
A list containing:
\item{Schwab_England_Score}{The input score formatted as a percentage.}
\item{Description}{The detailed clinical description of the patient's functional status.}
}
\references{
Schwab RS, England AC. Projection technique for evaluating surgery in Parkinson’s disease. In: Gillingham FJ, Donaldson MC, eds. Third Symposium on Parkinson’s Disease. Edinburgh, Scotland: E&S Livingstone; 1969:152-157.
}
\examples{

# Example 1: Mild Impairment
schwab_england_adl_scale(90)

# Example 2: Severe Dependence
schwab_england_adl_scale(30)
}
