\name{revised_schwartz_gfr}
\alias{revised_schwartz_gfr}
\title{
Revised Schwartz Equation for Pediatric GFR (2009)
}
\description{
Calculates the estimated Glomerular Filtration Rate (eGFR) for children and adolescents (ages 1-17) with chronic kidney disease using the "Bedside" Revised Schwartz Equation (2009). This updated formula uses a standardized constant (k=0.413) for methods where serum creatinine is measured via enzymatic assay (IDMS-traceable).
}
\usage{
revised_schwartz_gfr(height, serum_creatinine,
                     height_units = "cm", creatinine_units = "mg/dL")
}
\arguments{
  \item{height}{
Numeric. Patient height.
}
  \item{serum_creatinine}{
Numeric. Serum creatinine level.
}
  \item{height_units}{
String. Units for height input. Options: "cm" (default) or "in".
}
  \item{creatinine_units}{
String. Units for creatinine input. Options: "mg/dL" (default) or "umol/L" (or "micromol/L").
}
}
\details{
The formula is:
\deqn{eGFR = \frac{0.413 \times Height (cm)}{Serum Creatinine (mg/dL)}}
}
\value{
A list containing:
\item{Estimated_GFR}{The calculated eGFR in mL/min/1.73 m^2.}
\item{Interpretation}{CKD staging category based on the eGFR result.}
}
\references{
Schwartz GJ, Munoz A, Schneider MF, et al. New equations to estimate GFR in children with CKD. J Am Soc Nephrol. 2009;20(3):629-637. doi:10.1681/ASN.2008030287
}
\examples{

# Example 1: Normal Function
# Height 120 cm, Creatinine 0.5 mg/dL
# eGFR = (0.413 * 120) / 0.5 = 99.1
revised_schwartz_gfr(120, 0.5)

# Example 2: Renal Impairment
# Height 48 inches (122 cm), Creatinine 100 umol/L (1.13 mg/dL)
# eGFR = (0.413 * 121.92) / 1.13 = 44.6
revised_schwartz_gfr(48, 100, "in", "umol/L")
}
