\name{resp_ecmo_score}
\alias{resp_ecmo_score}
\title{
RESP Score for ECMO Survival Prediction
}
\description{
Calculates the Respiratory Extracorporeal Membrane Oxygenation Survival Prediction (RESP) score. This tool predicts in-hospital survival for adult patients undergoing ECMO for severe Acute Respiratory Distress Syndrome (ARDS). It stratifies patients into five risk classes based on 12 pre-ECMO variables.
}
\usage{
resp_ecmo_score(age, immunocompromised, mv_duration_hours, diagnosis_category,
                cns_dysfunction, acute_infection_non_pulm, neuromuscular_blockade,
                nitric_oxide_use, bicarbonate_use, cardiac_arrest, paco2_mmhg,
                pip_cmh2o)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
18-49: 0 pts.
50-59: -2 pts.
>=60: -3 pts.
}
  \item{immunocompromised}{
Numeric (0 or 1). Immunocompromised status (hematological malignancy, solid tumor, solid organ transplant, HIV, cirrhosis). (1 = Yes, -2 pts).
}
  \item{mv_duration_hours}{
Numeric. Duration of mechanical ventilation prior to ECMO initiation in hours.
< 48 hours: +3 pts.
48 hours - 7 days: +1 pt.
> 7 days: 0 pts.
}
  \item{diagnosis_category}{
String. Primary acute respiratory diagnosis.
"viral_pneumonia", "bacterial_pneumonia", "aspiration_pneumonitis", "trauma_burn": +3 pts.
"asthma": +11 pts.
"other_acute_respiratory" (e.g., inhalation injury, alveolar hemorrhage): +1 pt.
"chronic_non_respiratory" (e.g., chronic lung disease, non-respiratory cause): 0 pts.
}
  \item{cns_dysfunction}{
Numeric (0 or 1). Central nervous system dysfunction (neurotrauma, stroke, encephalopathy, seizure). (1 = Yes, -7 pts).
}
  \item{acute_infection_non_pulm}{
Numeric (0 or 1). Acute associated non-pulmonary infection. (1 = Yes, -3 pts).
}
  \item{neuromuscular_blockade}{
Numeric (0 or 1). Use of neuromuscular blockade agents before ECMO. (1 = Yes, +1 pt).
}
  \item{nitric_oxide_use}{
Numeric (0 or 1). Use of Nitric Oxide before ECMO. (1 = Yes, -1 pt).
}
  \item{bicarbonate_use}{
Numeric (0 or 1). Use of Bicarbonate infusion before ECMO. (1 = Yes, -2 pts).
}
  \item{cardiac_arrest}{
Numeric (0 or 1). Pre-ECMO cardiac arrest. (1 = Yes, -2 pts).
}
  \item{paco2_mmhg}{
Numeric. Partial pressure of arterial carbon dioxide in mmHg. (>= 75 mmHg: -2 pts).
}
  \item{pip_cmh2o}{
Numeric. Peak Inspiratory Pressure in cmH2O. (>= 42 cmH2O: -2 pts).
}
}
\value{
A list containing:
\item{RESP_Score}{The calculated total score (Range -22 to 15).}
\item{Risk_Class}{Risk classification (Class I to V).}
\item{Est_Hospital_Survival}{Estimated in-hospital survival percentage.}
}
\references{
Schmidt M, Bailey M, Sheldrake J, et al. Predicting survival for severe ARDS patients on extracorporeal membrane oxygenation: the RESP score. Am J Respir Crit Care Med. 2014;189(11):1374-1382. doi:10.1164/rccm.201311-2023OC
}
\examples{

# Example 1: Good Prognosis (Class I)
# 30yo (0), Asthma (+11), MV 10h (+3), NMB (+1)
# Score = 15
resp_ecmo_score(30, 0, 10, "asthma", 0, 0, 1, 0, 0, 0, 40, 30)

# Example 2: Poor Prognosis (Class IV)
# 65yo (-3), Bacterial PNA (+3), MV 8 days (0), Immuno (-2), CNS Dysfx (-7)
# Score = -9
resp_ecmo_score(65, 1, 200, "bacterial_pneumonia", 1, 0, 0, 0, 0, 0, 40, 30)
}
