\name{relative_fat_mass}
\alias{relative_fat_mass}
\title{
Relative Fat Mass (RFM)
}
\description{
Calculates the Relative Fat Mass (RFM), an estimator of whole-body fat percentage based on the ratio of height to waist circumference. It has been shown to be more accurate than BMI for diagnosing obesity.
}
\usage{
relative_fat_mass(sex, height, waist, units = "cm")
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{height}{
Numeric. Height. (Units must match waist).
}
  \item{waist}{
Numeric. Waist circumference. (Units must match height).
}
  \item{units}{
String. Units of measurement (e.g., "cm" or "in"). Used for display only; the ratio is unit-independent as long as both inputs match.
}
}
\details{
The formula is:
\itemize{
  \item Men: \eqn{64 - (20 \times \frac{Height}{Waist})}
  \item Women: \eqn{76 - (20 \times \frac{Height}{Waist})}
}
Cutoffs for obesity are typically cited as \eqn{\ge} 22.8\% for men and \eqn{\ge} 33.9\% for women.
}
\value{
A list containing:
\item{RFM_Percentage}{The estimated body fat percentage.}
\item{Interpretation}{Classification as Obese or Non-Obese based on validation cutoffs.}
}
\references{
Woolcott OO, Bergman RN. Relative fat mass (RFM) as a new estimator of whole-body fat percentage A cross-sectional study in American adult individuals. Sci Rep. 2018;8(1):10980. doi:10.1038/s41598-018-29362-1
}
\examples{

# Example 1: Male
# Height 180 cm, Waist 90 cm (Ratio 2.0)
# RFM = 64 - (20 * 2) = 24%
relative_fat_mass("male", 180, 90)

# Example 2: Female
# Height 165 cm, Waist 80 cm (Ratio 2.06)
# RFM = 76 - (20 * 2.06) = 34.8%
relative_fat_mass("female", 165, 80)
}
