\name{reids_colposcopic_index}
\alias{reids_colposcopic_index}
\title{
Reid's Colposcopic Index (RCI)
}
\description{
Calculates the Reid's Colposcopic Index (RCI) score to grade the severity of premalignant cervical lesions during colposcopy. The score is based on four colposcopic signs: lesion margin, color of acetowhitening, vascular patterns, and iodine staining response.
}
\usage{
reids_colposcopic_index(lesion_margin, acetowhitening_color, vascular_patterns,
                        iodine_staining)
}
\arguments{
  \item{lesion_margin}{
Numeric (0-2). Characteristics of the lesion margin.
0: Condylomatous or micropapillary contour; indistinct, flocculated, or feathered margins; jagged/angular lesions; satellite lesions beyond the transformation zone.
1: Regular lesions with smooth, straight outlines.
2: Rolled, peeling edges; internal borders between areas of differing appearance.
}
  \item{acetowhitening_color}{
Numeric (0-2). Color of the lesion after acetic acid application.
0: Shiny, snow-white; indistinct acetowhitening; semitransparent.
1: Shiny, off-white; intermediate white; gray-white.
2: Dull, oyster gray; dense/opaque acetowhitening.
}
  \item{vascular_patterns}{
Numeric (0-2). Characteristics of blood vessels within the lesion.
0: Uniform, fine-caliber vessels; poorly formed patterns; nondilated capillary loops.
1: Absence of surface vessels after acetic acid soaking.
2: Definite, coarse punctation or mosaicism; dilated vessels arranged in well-defined patterns.
}
  \item{iodine_staining}{
Numeric (0-2). Response to Lugol's iodine solution.
0: Positive iodine uptake (mahogany brown); or negative uptake (mustard yellow) in a lesion scoring <=2 points on the first three criteria.
1: Partial iodine uptake; variegated/tortoise-shell appearance.
2: Negative iodine uptake (mustard yellow) in a lesion scoring >=3 points on the first three criteria.
}
}
\value{
A list containing:
\item{RCI_Score}{The calculated total score (Range 0-8).}
\item{Predicted_Histology}{Predicted histologic grade (Low, Intermediate, or High grade).}
}
\references{
Reid R, Scalzi P. Genital warts and cervical cancer. VII. An improved colposcopic index for differentiating benign papillomaviral infections from high-grade cervical intraepithelial neoplasia. Am J Obstet Gynecol. 1985;153(6):611-618. doi:10.1016/0002-9378(85)90245-2
}
\examples{

# Example 1: High Grade Lesion
# Rolled edges (2), Dull gray (2), Coarse mosaic (2), Negative iodine (2)
# Score = 8
reids_colposcopic_index(2, 2, 2, 2)

# Example 2: Low Grade Lesion
# Irregular margin (0), Snow white (0), Fine vessels (0), Positive iodine (0)
# Score = 0
reids_colposcopic_index(0, 0, 0, 0)
}
