\name{pss_3_screener}
\alias{pss_3_screener}
\title{
ED-SAFE Patient Safety Screener 3 (PSS-3)
}
\description{
Implements the Patient Safety Screener-3 (PSS-3), a brief 3-item tool used in emergency departments and acute care settings to screen for suicide risk. It assesses depressed mood, active suicidal ideation, and lifetime suicide attempts.
}
\usage{
pss_3_screener(depressed_2weeks, suicidal_thoughts_2weeks,
               suicide_attempt_lifetime)
}
\arguments{
  \item{depressed_2weeks}{
Numeric (0 or 1). Over the past 2 weeks, have you felt down, depressed, or hopeless? (1 = Yes).
}
  \item{suicidal_thoughts_2weeks}{
Numeric (0 or 1). Over the past 2 weeks, have you had thoughts of killing yourself? (1 = Yes).
}
  \item{suicide_attempt_lifetime}{
Numeric (0 or 1). In your lifetime, have you ever attempted to kill yourself? (1 = Yes).
}
}
\value{
A list containing:
\item{Screen_Result}{"Positive" or "Negative" regarding suicide risk.}
\item{Risk_Interpretation}{Specific context on whether the screen flags suicide risk or depression only.}
\item{Recommended_Action}{Suggested clinical next steps (e.g., secondary screening, safety planning).}
}
\references{
Boudreaux ED, Camargo CA Jr, Arias SA, et al. Improving Suicide Risk Screening and Detection in the Emergency Department. Am J Prev Med. 2016;50(4):445-453. doi:10.1016/j.amepre.2015.09.029
}
\examples{

# Example 1: Suicide Risk Positive (Thoughts)
# Depressed (1), Thoughts (1), No Attempt (0)
pss_3_screener(1, 1, 0)

# Example 2: Depression Only (Suicide Risk Negative)
# Depressed (1), No Thoughts (0), No Attempt (0)
pss_3_screener(1, 0, 0)

# Example 3: Negative Screen
# No to all
pss_3_screener(0, 0, 0)
}
